(* ::Package:: *)

(* ::Title:: *)
(*Integration problems of the form x^m (a+b x+c x^2)^p*)


(* ::Section:: *)
(*Integrands of the form x^m (a+b x+c x^2)^p when b^2-4 a c=0*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a^2+2 a b x+b^2 x^2)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^m*(a^2 + 2*a*b*x + b^2*x^2), x, 3, (a^2*x^(1 + m))/(1 + m) + (2*a*b*x^(2 + m))/(2 + m) + (b^2*x^(3 + m))/(3 + m)}

{x^4*(a^2 + 2*a*b*x + b^2*x^2), x, 3, (a^2*x^5)/5 + (a*b*x^6)/3 + (b^2*x^7)/7}
{x^3*(a^2 + 2*a*b*x + b^2*x^2), x, 3, (a^2*x^4)/4 + (2*a*b*x^5)/5 + (b^2*x^6)/6}
{x^2*(a^2 + 2*a*b*x + b^2*x^2), x, 3, (a^2*x^3)/3 + (a*b*x^4)/2 + (b^2*x^5)/5}
{x*(a^2 + 2*a*b*x + b^2*x^2), x, 3, (a^2*x^2)/2 + (2/3)*a*b*x^3 + (b^2*x^4)/4}
{a^2 + 2*a*b*x + b^2*x^2, x, 1, a^2*x + a*b*x^2 + (b^2*x^3)/3}
{(a^2 + 2*a*b*x + b^2*x^2)/x, x, 3, 2*a*b*x + (b^2*x^2)/2 + a^2*Log[x]}
{(a^2 + 2*a*b*x + b^2*x^2)/x^2, x, 3, -(a^2/x) + b^2*x + 2*a*b*Log[x]}
{(a^2 + 2*a*b*x + b^2*x^2)/x^3, x, 3, -a^2/(2*x^2) - (2*a*b)/x + b^2*Log[x]}
{(a^2 + 2*a*b*x + b^2*x^2)/x^4, x, 2, -(a + b*x)^3/(3*a*x^3)}
{(a^2 + 2*a*b*x + b^2*x^2)/x^5, x, 3, -a^2/(4*x^4) - (2*a*b)/(3*x^3) - b^2/(2*x^2)}
{(a^2 + 2*a*b*x + b^2*x^2)/x^6, x, 3, -a^2/(5*x^5) - (a*b)/(2*x^4) - b^2/(3*x^3)}
{(a^2 + 2*a*b*x + b^2*x^2)/x^7, x, 3, -a^2/(6*x^6) - (2*a*b)/(5*x^5) - b^2/(4*x^4)}


{x^m*(a^2 + 2*a*b*x + b^2*x^2)^2, x, 3, (a^4*x^(1 + m))/(1 + m) + (4*a^3*b*x^(2 + m))/(2 + m) + (6*a^2*b^2*x^(3 + m))/(3 + m) + (4*a*b^3*x^(4 + m))/(4 + m) + (b^4*x^(5 + m))/(5 + m)}

{x^6*(a^2 + 2*a*b*x + b^2*x^2)^2, x, 3, (a^4*x^7)/7 + (a^3*b*x^8)/2 + (2*a^2*b^2*x^9)/3 + (2*a*b^3*x^10)/5 + (b^4*x^11)/11}
{x^5*(a^2 + 2*a*b*x + b^2*x^2)^2, x, 3, (a^4*x^6)/6 + (4*a^3*b*x^7)/7 + (3*a^2*b^2*x^8)/4 + (4*a*b^3*x^9)/9 + (b^4*x^10)/10}
{x^4*(a^2 + 2*a*b*x + b^2*x^2)^2, x, 3, (a^4*x^5)/5 + (2*a^3*b*x^6)/3 + (6*a^2*b^2*x^7)/7 + (a*b^3*x^8)/2 + (b^4*x^9)/9}
{x^3*(a^2 + 2*a*b*x + b^2*x^2)^2, x, 3, (a^4*x^4)/4 + (4*a^3*b*x^5)/5 + a^2*b^2*x^6 + (4*a*b^3*x^7)/7 + (b^4*x^8)/8}

{x^2*(a^2 + 2*a*b*x + b^2*x^2)^2, x, 3, (a^2*(a + b*x)^5)/(5*b^3) - (a*(a + b*x)^6)/(3*b^3) + (a + b*x)^7/(7*b^3)}
{x*(a^2 + 2*a*b*x + b^2*x^2)^2, x, 3, -(a*(a + b*x)^5)/(5*b^2) + (a + b*x)^6/(6*b^2)}
{(a^2 + 2*a*b*x + b^2*x^2)^2, x, 2, (a + b*x)^5/(5*b)}

{(a^2 + 2*a*b*x + b^2*x^2)^2/x, x, 3, 4*a^3*b*x + 3*a^2*b^2*x^2 + (4*a*b^3*x^3)/3 + (b^4*x^4)/4 + a^4*Log[x]}
{(a^2 + 2*a*b*x + b^2*x^2)^2/x^2, x, 3, -(a^4/x) + 6*a^2*b^2*x + 2*a*b^3*x^2 + (b^4*x^3)/3 + 4*a^3*b*Log[x]}
{(a^2 + 2*a*b*x + b^2*x^2)^2/x^3, x, 3, -a^4/(2*x^2) - (4*a^3*b)/x + 4*a*b^3*x + (b^4*x^2)/2 + 6*a^2*b^2*Log[x]}
{(a^2 + 2*a*b*x + b^2*x^2)^2/x^4, x, 3, -a^4/(3*x^3) - (2*a^3*b)/x^2 - (6*a^2*b^2)/x + b^4*x + 4*a*b^3*Log[x]}
{(a^2 + 2*a*b*x + b^2*x^2)^2/x^5, x, 3, -a^4/(4*x^4) - (4*a^3*b)/(3*x^3) - (3*a^2*b^2)/x^2 - (4*a*b^3)/x + b^4*Log[x]}

{(a^2 + 2*a*b*x + b^2*x^2)^2/x^6, x, 2, -(a + b*x)^5/(5*a*x^5)}
(* {(a^2 + 2*a*b*x + b^2*x^2)^2/x^7, x, 3, -(a + b*x)^5/(6*a*x^6) + (b*(a + b*x)^5)/(30*a^2*x^5)} *)

{(a^2 + 2*a*b*x + b^2*x^2)^2/x^7, x, 3, -(a^4/(6*x^6)) - (4*a^3*b)/(5*x^5) - (3*a^2*b^2)/(2*x^4) - (4*a*b^3)/(3*x^3) - b^4/(2*x^2)}
{(a^2 + 2*a*b*x + b^2*x^2)^2/x^8, x, 3, -(a^4/(7*x^7)) - (2*a^3*b)/(3*x^6) - (6*a^2*b^2)/(5*x^5) - (a*b^3)/x^4 - b^4/(3*x^3)}
{(a^2 + 2*a*b*x + b^2*x^2)^2/x^9, x, 3, -a^4/(8*x^8) - (4*a^3*b)/(7*x^7) - (a^2*b^2)/x^6 - (4*a*b^3)/(5*x^5) - b^4/(4*x^4)}
{(a^2 + 2*a*b*x + b^2*x^2)^2/x^10, x, 3, -a^4/(9*x^9) - (a^3*b)/(2*x^8) - (6*a^2*b^2)/(7*x^7) - (2*a*b^3)/(3*x^6) - b^4/(5*x^5)}
{(a^2 + 2*a*b*x + b^2*x^2)^2/x^11, x, 3, -a^4/(10*x^10) - (4*a^3*b)/(9*x^9) - (3*a^2*b^2)/(4*x^8) - (4*a*b^3)/(7*x^7) - b^4/(6*x^6)}


{x^m*(a^2 + 2*a*b*x + b^2*x^2)^3, x, 3, (a^6*x^(1 + m))/(1 + m) + (6*a^5*b*x^(2 + m))/(2 + m) + (15*a^4*b^2*x^(3 + m))/(3 + m) + (20*a^3*b^3*x^(4 + m))/(4 + m) + (15*a^2*b^4*x^(5 + m))/(5 + m) + (6*a*b^5*x^(6 + m))/(6 + m) + (b^6*x^(7 + m))/(7 + m)}

{x^7*(a^2 + 2*a*b*x + b^2*x^2)^3, x, 3, (a^6*x^8)/8 + (2*a^5*b*x^9)/3 + (3*a^4*b^2*x^10)/2 + (20*a^3*b^3*x^11)/11 + (5*a^2*b^4*x^12)/4 + (6*a*b^5*x^13)/13 + (b^6*x^14)/14}
{x^6*(a^2 + 2*a*b*x + b^2*x^2)^3, x, 3, (a^6*x^7)/7 + (3*a^5*b*x^8)/4 + (5*a^4*b^2*x^9)/3 + 2*a^3*b^3*x^10 + (15*a^2*b^4*x^11)/11 + (a*b^5*x^12)/2 + (b^6*x^13)/13}
{x^5*(a^2 + 2*a*b*x + b^2*x^2)^3, x, 3, (a^6*x^6)/6 + (6*a^5*b*x^7)/7 + (15*a^4*b^2*x^8)/8 + (20*a^3*b^3*x^9)/9 + (3*a^2*b^4*x^10)/2 + (6*a*b^5*x^11)/11 + (b^6*x^12)/12}
{x^4*(a^2 + 2*a*b*x + b^2*x^2)^3, x, 3, (a^6*x^5)/5 + a^5*b*x^6 + (15*a^4*b^2*x^7)/7 + (5*a^3*b^3*x^8)/2 + (5*a^2*b^4*x^9)/3 + (3*a*b^5*x^10)/5 + (b^6*x^11)/11}

{x^3*(a^2 + 2*a*b*x + b^2*x^2)^3, x, 3, -((a^3*(a + b*x)^7)/(7*b^4)) + (3*a^2*(a + b*x)^8)/(8*b^4) - (a*(a + b*x)^9)/(3*b^4) + (a + b*x)^10/(10*b^4)}
{x^2*(a^2 + 2*a*b*x + b^2*x^2)^3, x, 3, (a^2*(a + b*x)^7)/(7*b^3) - (a*(a + b*x)^8)/(4*b^3) + (a + b*x)^9/(9*b^3)}
{x*(a^2 + 2*a*b*x + b^2*x^2)^3, x, 3, -(a*(a + b*x)^7)/(7*b^2) + (a + b*x)^8/(8*b^2)}
{(a^2 + 2*a*b*x + b^2*x^2)^3, x, 2, (a + b*x)^7/(7*b)}

{(a^2 + 2*a*b*x + b^2*x^2)^3/x, x, 3, 6*a^5*b*x + (15*a^4*b^2*x^2)/2 + (20*a^3*b^3*x^3)/3 + (15*a^2*b^4*x^4)/4 + (6*a*b^5*x^5)/5 + (b^6*x^6)/6 + a^6*Log[x]}
{(a^2 + 2*a*b*x + b^2*x^2)^3/x^2, x, 3, -(a^6/x) + 15*a^4*b^2*x + 10*a^3*b^3*x^2 + 5*a^2*b^4*x^3 + (3*a*b^5*x^4)/2 + (b^6*x^5)/5 + 6*a^5*b*Log[x]}
{(a^2 + 2*a*b*x + b^2*x^2)^3/x^3, x, 3, -a^6/(2*x^2) - (6*a^5*b)/x + 20*a^3*b^3*x + (15*a^2*b^4*x^2)/2 + 2*a*b^5*x^3 + (b^6*x^4)/4 + 15*a^4*b^2*Log[x]}
{(a^2 + 2*a*b*x + b^2*x^2)^3/x^4, x, 3, -a^6/(3*x^3) - (3*a^5*b)/x^2 - (15*a^4*b^2)/x + 15*a^2*b^4*x + 3*a*b^5*x^2 + (b^6*x^3)/3 + 20*a^3*b^3*Log[x]}
{(a^2 + 2*a*b*x + b^2*x^2)^3/x^5, x, 3, -a^6/(4*x^4) - (2*a^5*b)/x^3 - (15*a^4*b^2)/(2*x^2) - (20*a^3*b^3)/x + 6*a*b^5*x + (b^6*x^2)/2 + 15*a^2*b^4*Log[x]}
{(a^2 + 2*a*b*x + b^2*x^2)^3/x^6, x, 3, -a^6/(5*x^5) - (3*a^5*b)/(2*x^4) - (5*a^4*b^2)/x^3 - (10*a^3*b^3)/x^2 - (15*a^2*b^4)/x + b^6*x + 6*a*b^5*Log[x]}
{(a^2 + 2*a*b*x + b^2*x^2)^3/x^7, x, 3, -a^6/(6*x^6) - (6*a^5*b)/(5*x^5) - (15*a^4*b^2)/(4*x^4) - (20*a^3*b^3)/(3*x^3) - (15*a^2*b^4)/(2*x^2) - (6*a*b^5)/x + b^6*Log[x]}

{(a^2 + 2*a*b*x + b^2*x^2)^3/x^8, x, 2, -(a + b*x)^7/(7*a*x^7)}
{(a^2 + 2*a*b*x + b^2*x^2)^3/x^9, x, 3, -(a + b*x)^7/(8*a*x^8) + (b*(a + b*x)^7)/(56*a^2*x^7)}
{(a^2 + 2*a*b*x + b^2*x^2)^3/x^10, x, 4, -(a + b*x)^7/(9*a*x^9) + (b*(a + b*x)^7)/(36*a^2*x^8) - (b^2*(a + b*x)^7)/(252*a^3*x^7)}

{(a^2 + 2*a*b*x + b^2*x^2)^3/x^11, x, 3, -(a^6/(10*x^10)) - (2*a^5*b)/(3*x^9) - (15*a^4*b^2)/(8*x^8) - (20*a^3*b^3)/(7*x^7) - (5*a^2*b^4)/(2*x^6) - (6*a*b^5)/(5*x^5) - b^6/(4*x^4)}
{(a^2 + 2*a*b*x + b^2*x^2)^3/x^12, x, 3, -a^6/(11*x^11) - (3*a^5*b)/(5*x^10) - (5*a^4*b^2)/(3*x^9) - (5*a^3*b^3)/(2*x^8) - (15*a^2*b^4)/(7*x^7) - (a*b^5)/x^6 - b^6/(5*x^5)}
{(a^2 + 2*a*b*x + b^2*x^2)^3/x^13, x, 3, -a^6/(12*x^12) - (6*a^5*b)/(11*x^11) - (3*a^4*b^2)/(2*x^10) - (20*a^3*b^3)/(9*x^9) - (15*a^2*b^4)/(8*x^8) - (6*a*b^5)/(7*x^7) - b^6/(6*x^6)}
{(a^2 + 2*a*b*x + b^2*x^2)^3/x^14, x, 3, -a^6/(13*x^13) - (a^5*b)/(2*x^12) - (15*a^4*b^2)/(11*x^11) - (2*a^3*b^3)/x^10 - (5*a^2*b^4)/(3*x^9) - (3*a*b^5)/(4*x^8) - b^6/(7*x^7)}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^5/(a^2 + 2*a*b*x + b^2*x^2), x, 3, -((4*a^3*x)/b^5) + (3*a^2*x^2)/(2*b^4) - (2*a*x^3)/(3*b^3) + x^4/(4*b^2) + a^5/(b^6*(a + b*x)) + (5*a^4*Log[a + b*x])/b^6}
{x^4/(a^2 + 2*a*b*x + b^2*x^2), x, 3, (3*a^2*x)/b^4 - (a*x^2)/b^3 + x^3/(3*b^2) - a^4/(b^5*(a + b*x)) - (4*a^3*Log[a + b*x])/b^5}
{x^3/(a^2 + 2*a*b*x + b^2*x^2), x, 3, -((2*a*x)/b^3) + x^2/(2*b^2) + a^3/(b^4*(a + b*x)) + (3*a^2*Log[a + b*x])/b^4}
{x^2/(a^2 + 2*a*b*x + b^2*x^2), x, 3, x/b^2 - a^2/(b^3*(a + b*x)) - (2*a*Log[a + b*x])/b^3}
{x/(a^2 + 2*a*b*x + b^2*x^2), x, 3, a/(b^2*(a + b*x)) + Log[a + b*x]/b^2}
{(a^2 + 2*a*b*x + b^2*x^2)^(-1), x, 2, -(1/(b*(a + b*x)))}
{1/(x*(a^2 + 2*a*b*x + b^2*x^2)), x, 3, 1/(a*(a + b*x)) + Log[x]/a^2 - Log[a + b*x]/a^2}
{1/(x^2*(a^2 + 2*a*b*x + b^2*x^2)), x, 3, -(1/(a^2*x)) - b/(a^2*(a + b*x)) - (2*b*Log[x])/a^3 + (2*b*Log[a + b*x])/a^3}
{1/(x^3*(a^2 + 2*a*b*x + b^2*x^2)), x, 3, -(1/(2*a^2*x^2)) + (2*b)/(a^3*x) + b^2/(a^3*(a + b*x)) + (3*b^2*Log[x])/a^4 - (3*b^2*Log[a + b*x])/a^4}
{1/(x^4*(a^2 + 2*a*b*x + b^2*x^2)), x, 3, -(1/(3*a^2*x^3)) + b/(a^3*x^2) - (3*b^2)/(a^4*x) - b^3/(a^4*(a + b*x)) - (4*b^3*Log[x])/a^5 + (4*b^3*Log[a + b*x])/a^5}


{x^6/(a^2 + 2*a*b*x + b^2*x^2)^2, x, 3, (10*a^2*x)/b^6 - (2*a*x^2)/b^5 + x^3/(3*b^4) - a^6/(3*b^7*(a + b*x)^3) + (3*a^5)/(b^7*(a + b*x)^2) - (15*a^4)/(b^7*(a + b*x)) - (20*a^3*Log[a + b*x])/b^7}
{x^5/(a^2 + 2*a*b*x + b^2*x^2)^2, x, 3, -((4*a*x)/b^5) + x^2/(2*b^4) + a^5/(3*b^6*(a + b*x)^3) - (5*a^4)/(2*b^6*(a + b*x)^2) + (10*a^3)/(b^6*(a + b*x)) + (10*a^2*Log[a + b*x])/b^6}
{x^4/(a^2 + 2*a*b*x + b^2*x^2)^2, x, 3, x/b^4 - a^4/(3*b^5*(a + b*x)^3) + (2*a^3)/(b^5*(a + b*x)^2) - (6*a^2)/(b^5*(a + b*x)) - (4*a*Log[a + b*x])/b^5}
{x^3/(a^2 + 2*a*b*x + b^2*x^2)^2, x, 3, a^3/(3*b^4*(a + b*x)^3) - (3*a^2)/(2*b^4*(a + b*x)^2) + (3*a)/(b^4*(a + b*x)) + Log[a + b*x]/b^4}
{x^2/(a^2 + 2*a*b*x + b^2*x^2)^2, x, 2, x^3/(3*a*(a + b*x)^3)}
{x/(a^2 + 2*a*b*x + b^2*x^2)^2, x, 3, a/(3*b^2*(a + b*x)^3) - 1/(2*b^2*(a + b*x)^2)}
{(a^2 + 2*a*b*x + b^2*x^2)^(-2), x, 2, -1/(3*b*(a + b*x)^3)}
{1/(x*(a^2 + 2*a*b*x + b^2*x^2)^2), x, 3, 1/(3*a*(a + b*x)^3) + 1/(2*a^2*(a + b*x)^2) + 1/(a^3*(a + b*x)) + Log[x]/a^4 - Log[a + b*x]/a^4}
{1/(x^2*(a^2 + 2*a*b*x + b^2*x^2)^2), x, 3, -(1/(a^4*x)) - b/(3*a^2*(a + b*x)^3) - b/(a^3*(a + b*x)^2) - (3*b)/(a^4*(a + b*x)) - (4*b*Log[x])/a^5 + (4*b*Log[a + b*x])/a^5}
{1/(x^3*(a^2 + 2*a*b*x + b^2*x^2)^2), x, 3, -(1/(2*a^4*x^2)) + (4*b)/(a^5*x) + b^2/(3*a^3*(a + b*x)^3) + (3*b^2)/(2*a^4*(a + b*x)^2) + (6*b^2)/(a^5*(a + b*x)) + (10*b^2*Log[x])/a^6 - (10*b^2*Log[a + b*x])/a^6}


{x^8/(a^2 + 2*a*b*x + b^2*x^2)^3, x, 3, (21*a^2*x)/b^8 - (3*a*x^2)/b^7 + x^3/(3*b^6) - a^8/(5*b^9*(a + b*x)^5) + (2*a^7)/(b^9*(a + b*x)^4) - (28*a^6)/(3*b^9*(a + b*x)^3) + (28*a^5)/(b^9*(a + b*x)^2) - (70*a^4)/(b^9*(a + b*x)) - (56*a^3*Log[a + b*x])/b^9}
{x^7/(a^2 + 2*a*b*x + b^2*x^2)^3, x, 3, -((6*a*x)/b^7) + x^2/(2*b^6) + a^7/(5*b^8*(a + b*x)^5) - (7*a^6)/(4*b^8*(a + b*x)^4) + (7*a^5)/(b^8*(a + b*x)^3) - (35*a^4)/(2*b^8*(a + b*x)^2) + (35*a^3)/(b^8*(a + b*x)) + (21*a^2*Log[a + b*x])/b^8}
{x^6/(a^2 + 2*a*b*x + b^2*x^2)^3, x, 3, x/b^6 - a^6/(5*b^7*(a + b*x)^5) + (3*a^5)/(2*b^7*(a + b*x)^4) - (5*a^4)/(b^7*(a + b*x)^3) + (10*a^3)/(b^7*(a + b*x)^2) - (15*a^2)/(b^7*(a + b*x)) - (6*a*Log[a + b*x])/b^7}
{x^5/(a^2 + 2*a*b*x + b^2*x^2)^3, x, 3, a^5/(5*b^6*(a + b*x)^5) - (5*a^4)/(4*b^6*(a + b*x)^4) + (10*a^3)/(3*b^6*(a + b*x)^3) - (5*a^2)/(b^6*(a + b*x)^2) + (5*a)/(b^6*(a + b*x)) + Log[a + b*x]/b^6}
{x^4/(a^2 + 2*a*b*x + b^2*x^2)^3, x, 2, x^5/(5*a*(a + b*x)^5)}
{x^3/(a^2 + 2*a*b*x + b^2*x^2)^3, x, 3, x^4/(5*a*(a + b*x)^5) + x^4/(20*a^2*(a + b*x)^4)}
{x^2/(a^2 + 2*a*b*x + b^2*x^2)^3, x, 3, -(a^2/(5*b^3*(a + b*x)^5)) + a/(2*b^3*(a + b*x)^4) - 1/(3*b^3*(a + b*x)^3)}
{x/(a^2 + 2*a*b*x + b^2*x^2)^3, x, 3, a/(5*b^2*(a + b*x)^5) - 1/(4*b^2*(a + b*x)^4)}
{(a^2 + 2*a*b*x + b^2*x^2)^(-3), x, 2, -1/(5*b*(a + b*x)^5)}
{1/(x*(a^2 + 2*a*b*x + b^2*x^2)^3), x, 3, 1/(5*a*(a + b*x)^5) + 1/(4*a^2*(a + b*x)^4) + 1/(3*a^3*(a + b*x)^3) + 1/(2*a^4*(a + b*x)^2) + 1/(a^5*(a + b*x)) + Log[x]/a^6 - Log[a + b*x]/a^6}
{1/(x^2*(a^2 + 2*a*b*x + b^2*x^2)^3), x, 3, -(1/(a^6*x)) - b/(5*a^2*(a + b*x)^5) - b/(2*a^3*(a + b*x)^4) - b/(a^4*(a + b*x)^3) - (2*b)/(a^5*(a + b*x)^2) - (5*b)/(a^6*(a + b*x)) - (6*b*Log[x])/a^7 + (6*b*Log[a + b*x])/a^7}
{1/(x^3*(a^2 + 2*a*b*x + b^2*x^2)^3), x, 3, -(1/(2*a^6*x^2)) + (6*b)/(a^7*x) + b^2/(5*a^3*(a + b*x)^5) + (3*b^2)/(4*a^4*(a + b*x)^4) + (2*b^2)/(a^5*(a + b*x)^3) + (5*b^2)/(a^6*(a + b*x)^2) + (15*b^2)/(a^7*(a + b*x)) + (21*b^2*Log[x])/a^8 - (21*b^2*Log[a + b*x])/a^8}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a^2+2 a b x+b^2 x^2)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^m*Sqrt[a^2 + 2*a*b*x + b^2*x^2], x, 2, (x^(1 + m)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(2 + m) + (a*x^(1 + m)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/((2 + 3*m + m^2)*(a + b*x))}

{x^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2], x, 2, (1/6)*x^5*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (a*x^5*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(30*(a + b*x))}
{x^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2], x, 2, (1/5)*x^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (a*x^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(20*(a + b*x))}
{x^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2], x, 2, (1/4)*x^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (a*x^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(12*(a + b*x))}
{x*Sqrt[a^2 + 2*a*b*x + b^2*x^2], x, 2, -(a*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(2*b^2) + (a^2 + 2*a*b*x + b^2*x^2)^(3/2)/(3*b^2)}
{Sqrt[a^2 + 2*a*b*x + b^2*x^2], x, 1, ((a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(2*b)}
{Sqrt[a^2 + 2*a*b*x + b^2*x^2]/x, x, 2, Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (a*Sqrt[a^2 + 2*a*b*x + b^2*x^2]*Log[x])/(a + b*x)}
{Sqrt[a^2 + 2*a*b*x + b^2*x^2]/x^2, x, 3, -((a*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(x*(a + b*x))) + (b*Sqrt[a^2 + 2*a*b*x + b^2*x^2]*Log[x])/(a + b*x)}
{Sqrt[a^2 + 2*a*b*x + b^2*x^2]/x^3, x, 1, -(((a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(2*a*x^2))}
{Sqrt[a^2 + 2*a*b*x + b^2*x^2]/x^4, x, 2, -(Sqrt[a^2 + 2*a*b*x + b^2*x^2]/(2*x^3)) + (a*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(6*x^3*(a + b*x))}
{Sqrt[a^2 + 2*a*b*x + b^2*x^2]/x^5, x, 2, -(Sqrt[a^2 + 2*a*b*x + b^2*x^2]/(3*x^4)) + (a*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(12*x^4*(a + b*x))}
{Sqrt[a^2 + 2*a*b*x + b^2*x^2]/x^6, x, 2, -(Sqrt[a^2 + 2*a*b*x + b^2*x^2]/(4*x^5)) + (a*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(20*x^5*(a + b*x))}


{x^m*(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x, 3, (6*a^2*x^(1 + m)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(24 + 26*m + 9*m^2 + m^3) + (6*a^3*x^(1 + m)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/((3 + m)*(4 + m)*(2 + 3*m + m^2)*(a + b*x)) + (3*a*x^(1 + m)*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/((3 + m)*(4 + m)) + (x^(1 + m)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(4 + m)}

{x^5*(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x, 3, (1/84)*a^2*x^6*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (a^3*x^6*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(504*(a + b*x)) + (1/24)*a*x^6*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (1/9)*x^6*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)}
{x^4*(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x, 3, (1/56)*a^2*x^5*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (a^3*x^5*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(280*(a + b*x)) + (3/56)*a*x^5*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (1/8)*x^5*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)}
{x^3*(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x, 3, (1/35)*a^2*x^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (a^3*x^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(140*(a + b*x)) + (1/14)*a*x^4*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (1/7)*x^4*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)}
{x^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x, 3, (a^2*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(12*b^3) + (x^2*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(6*b) - (a*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(15*b^3)}
{x*(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x, 2, -(a*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(4*b^2) + (a^2 + 2*a*b*x + b^2*x^2)^(5/2)/(5*b^2)}
{(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x, 1, ((a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(4*b)}
{(a^2 + 2*a*b*x + b^2*x^2)^(3/2)/x, x, 3, a^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (1/2)*a*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (1/3)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) + (a^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2]*Log[x])/(a + b*x)}
{(a^2 + 2*a*b*x + b^2*x^2)^(3/2)/x^2, x, 3, 3*a*b*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (3/2)*b*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] - (a^2 + 2*a*b*x + b^2*x^2)^(3/2)/x + (3*a^2*b*Sqrt[a^2 + 2*a*b*x + b^2*x^2]*Log[x])/(a + b*x)}
{(a^2 + 2*a*b*x + b^2*x^2)^(3/2)/x^3, x, 3, 3*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2] - (3*b*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(2*x) - (a^2 + 2*a*b*x + b^2*x^2)^(3/2)/(2*x^2) + (3*a*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]*Log[x])/(a + b*x)}
{(a^2 + 2*a*b*x + b^2*x^2)^(3/2)/x^4, x, 4, -((a*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(x*(a + b*x))) - (b*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(2*x^2) - (a^2 + 2*a*b*x + b^2*x^2)^(3/2)/(3*x^3) + (b^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2]*Log[x])/(a + b*x)}
{(a^2 + 2*a*b*x + b^2*x^2)^(3/2)/x^5, x, 1, -((a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(4*a*x^4)}
{(a^2 + 2*a*b*x + b^2*x^2)^(3/2)/x^6, x, 1, -(((a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(4*a*x^5)) + (a^2 + 2*a*b*x + b^2*x^2)^(5/2)/(20*a^2*x^5)}
{(a^2 + 2*a*b*x + b^2*x^2)^(3/2)/x^7, x, 2, -(((a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(6*a*x^6)) + (b*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(12*a^2*x^5) - (b*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(60*a^3*x^5)}
{(a^2 + 2*a*b*x + b^2*x^2)^(3/2)/x^8, x, 3, -((b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(28*x^5)) + (a*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(140*x^5*(a + b*x)) - (b*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(14*x^6) - (a^2 + 2*a*b*x + b^2*x^2)^(3/2)/(7*x^7)}
{(a^2 + 2*a*b*x + b^2*x^2)^(3/2)/x^9, x, 3, -((3*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(140*x^6)) + (a*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(280*x^6*(a + b*x)) - (3*b*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(56*x^7) - (a^2 + 2*a*b*x + b^2*x^2)^(3/2)/(8*x^8)}


{x^m*(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 4, (120*a^4*x^(1 + m)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/((5 + m)*(6 + m)*(24 + 26*m + 9*m^2 + m^3)) + (120*a^5*x^(1 + m)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/((3 + m)*(4 + m)*(5 + m)*(6 + m)*(2 + 3*m + m^2)*(a + b*x)) + (60*a^3*x^(1 + m)*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/((3 + m)*(4 + m)*(5 + m)*(6 + m)) + (20*a^2*x^(1 + m)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/((4 + m)*(5 + m)*(6 + m)) + (5*a*x^(1 + m)*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/((5 + m)*(6 + m)) + (x^(1 + m)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(6 + m)}

{x^7*(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 4, (a^4*x^8*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/1287 + (a^5*x^8*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(10296*(a + b*x)) + (1/286)*a^3*x^8*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (5/429)*a^2*x^8*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) + (5/156)*a*x^8*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) + (1/13)*x^8*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)}
{x^6*(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 4, (1/792)*a^4*x^7*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (a^5*x^7*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(5544*(a + b*x)) + (1/198)*a^3*x^7*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (1/66)*a^2*x^7*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) + (5/132)*a*x^7*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) + (1/12)*x^7*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)}
{x^5*(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 4, (1/462)*a^4*x^6*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (a^5*x^6*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(2772*(a + b*x)) + (1/132)*a^3*x^6*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (2/99)*a^2*x^6*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) + (1/22)*a*x^6*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) + (1/11)*x^6*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)}
{x^4*(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 5, (a^4*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(180*b^5) + (a^2*x^2*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(60*b^3) - (2*a*x^3*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(45*b^2) + (x^4*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(10*b) - (a^3*(a^2 + 2*a*b*x + b^2*x^2)^(7/2))/(210*b^5)}
{x^3*(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 4, -(a^3*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(72*b^4) - (a*x^2*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(24*b^2) + (x^3*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(9*b) + (a^2*(a^2 + 2*a*b*x + b^2*x^2)^(7/2))/(84*b^4)}
{x^2*(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 3, (a^2*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(24*b^3) + (x^2*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(8*b) - (a*(a^2 + 2*a*b*x + b^2*x^2)^(7/2))/(28*b^3)}
{x*(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 2, -(a*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(6*b^2) + (a^2 + 2*a*b*x + b^2*x^2)^(7/2)/(7*b^2)}
{(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 1, ((a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(6*b)}
{(a^2 + 2*a*b*x + b^2*x^2)^(5/2)/x, x, 4, a^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (1/2)*a^3*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (1/3)*a^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) + (1/4)*a*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) + (1/5)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2) + (a^5*Sqrt[a^2 + 2*a*b*x + b^2*x^2]*Log[x])/(a + b*x)}
{(a^2 + 2*a*b*x + b^2*x^2)^(5/2)/x^2, x, 4, 5*a^3*b*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (5/2)*a^2*b*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (5/3)*a*b*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) + (5/4)*b*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) - (a^2 + 2*a*b*x + b^2*x^2)^(5/2)/x + (5*a^4*b*Sqrt[a^2 + 2*a*b*x + b^2*x^2]*Log[x])/(a + b*x)}
{(a^2 + 2*a*b*x + b^2*x^2)^(5/2)/x^3, x, 4, 10*a^2*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + 5*a*b^2*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (10/3)*b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) - (5*b*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(2*x) - (a^2 + 2*a*b*x + b^2*x^2)^(5/2)/(2*x^2) + (10*a^3*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]*Log[x])/(a + b*x)}
{(a^2 + 2*a*b*x + b^2*x^2)^(5/2)/x^4, x, 4, 10*a*b^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + 5*b^3*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] - (10*b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(3*x) - (5*b*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(6*x^2) - (a^2 + 2*a*b*x + b^2*x^2)^(5/2)/(3*x^3) + (10*a^2*b^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2]*Log[x])/(a + b*x)}
{(a^2 + 2*a*b*x + b^2*x^2)^(5/2)/x^5, x, 4, 5*b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2] - (5*b^3*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(2*x) - (5*b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(6*x^2) - (5*b*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(12*x^3) - (a^2 + 2*a*b*x + b^2*x^2)^(5/2)/(4*x^4) + (5*a*b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2]*Log[x])/(a + b*x)}
{(a^2 + 2*a*b*x + b^2*x^2)^(5/2)/x^6, x, 5, -((a*b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(x*(a + b*x))) - (b^3*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(2*x^2) - (b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(3*x^3) - (b*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(4*x^4) - (a^2 + 2*a*b*x + b^2*x^2)^(5/2)/(5*x^5) + (b^5*Sqrt[a^2 + 2*a*b*x + b^2*x^2]*Log[x])/(a + b*x)}
{(a^2 + 2*a*b*x + b^2*x^2)^(5/2)/x^7, x, 1, -((a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(6*a*x^6)}
{(a^2 + 2*a*b*x + b^2*x^2)^(5/2)/x^8, x, 1, -(((a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(6*a*x^7)) + (a^2 + 2*a*b*x + b^2*x^2)^(7/2)/(42*a^2*x^7)}
{(a^2 + 2*a*b*x + b^2*x^2)^(5/2)/x^9, x, 2, -(((a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(8*a*x^8)) + (b*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(24*a^2*x^7) - (b*(a^2 + 2*a*b*x + b^2*x^2)^(7/2))/(168*a^3*x^7)}
{(a^2 + 2*a*b*x + b^2*x^2)^(5/2)/x^10, x, 3, -(((a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(9*a*x^9)) + (b*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(24*a^2*x^8) - (b^2*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(72*a^3*x^7) + (b^2*(a^2 + 2*a*b*x + b^2*x^2)^(7/2))/(504*a^4*x^7)}
{(a^2 + 2*a*b*x + b^2*x^2)^(5/2)/x^11, x, 4, -((b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(210*x^6)) + (a*b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(1260*x^6*(a + b*x)) - (b^3*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(84*x^7) - (b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(36*x^8) - (b*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(18*x^9) - (a^2 + 2*a*b*x + b^2*x^2)^(5/2)/(10*x^10)}
{(a^2 + 2*a*b*x + b^2*x^2)^(5/2)/x^12, x, 4, -((b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(396*x^7)) + (a*b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(2772*x^7*(a + b*x)) - (b^3*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(132*x^8) - (2*b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(99*x^9) - (b*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(22*x^10) - (a^2 + 2*a*b*x + b^2*x^2)^(5/2)/(11*x^11)}
{(a^2 + 2*a*b*x + b^2*x^2)^(5/2)/x^13, x, 4, -((b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(693*x^8)) + (a*b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(5544*x^8*(a + b*x)) - (b^3*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(198*x^9) - (b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(66*x^10) - (5*b*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(132*x^11) - (a^2 + 2*a*b*x + b^2*x^2)^(5/2)/(12*x^12)}


{Sqrt[4 + 12*x + 9*x^2], x, 1, (1/6)*(2 + 3*x)*Sqrt[4 + 12*x + 9*x^2]}
{Sqrt[4 - 12*x + 9*x^2], x, 1, (-(1/6))*(2 - 3*x)*Sqrt[4 - 12*x + 9*x^2]}
{Sqrt[-4 + 12*x - 9*x^2], x, 1, (-(1/6))*(2 - 3*x)*Sqrt[-4 + 12*x - 9*x^2]}
{Sqrt[-4 - 12*x - 9*x^2], x, 1, (1/6)*(2 + 3*x)*Sqrt[-4 - 12*x - 9*x^2]}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^4/Sqrt[a^2 + 2*a*b*x + b^2*x^2], x, 6, (a^2*x^2*(a + b*x))/(2*b^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (a*x^3*(a + b*x))/(3*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (x^4*(a + b*x))/(4*b*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (a^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/b^5 + (a^4*(a + b*x)*Log[a + b*x])/(b^5*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{x^3/Sqrt[a^2 + 2*a*b*x + b^2*x^2], x, 5, -(a*x^2*(a + b*x))/(2*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (x^3*(a + b*x))/(3*b*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (a^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/b^4 - (a^3*(a + b*x)*Log[a + b*x])/(b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{x^2/Sqrt[a^2 + 2*a*b*x + b^2*x^2], x, 4, (x^2*(a + b*x))/(2*b*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (a*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/b^3 + (a^2*(a + b*x)*Log[a + b*x])/(b^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{x/Sqrt[a^2 + 2*a*b*x + b^2*x^2], x, 3, Sqrt[a^2 + 2*a*b*x + b^2*x^2]/b^2 - (a*(a + b*x)*Log[a + b*x])/(b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/Sqrt[a^2 + 2*a*b*x + b^2*x^2], x, 2, ((a + b*x)*Log[a + b*x])/(b*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(x*Sqrt[a^2 + 2*a*b*x + b^2*x^2]), x, 3, ((a + b*x)*Log[x])/(a*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - ((a + b*x)*Log[a + b*x])/(a*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(x^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]), x, 4, -(Sqrt[a^2 + 2*a*b*x + b^2*x^2]/(a^2*x)) - (b*(a + b*x)*Log[x])/(a^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (b*(a + b*x)*Log[a + b*x])/(a^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(x^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2]), x, 5, -(a + b*x)/(2*a*x^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (b*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(a^3*x) + (b^2*(a + b*x)*Log[x])/(a^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (b^2*(a + b*x)*Log[a + b*x])/(a^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(x^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2]), x, 6, -(a + b*x)/(3*a*x^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (b*(a + b*x))/(2*a^2*x^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(a^4*x) - (b^3*(a + b*x)*Log[x])/(a^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (b^3*(a + b*x)*Log[a + b*x])/(a^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}


{x^5/(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x, 6, -((x^5*(a + b*x))/(2*b*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))) - (5*x^4)/(2*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (5*a*x^2*(a + b*x))/(b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (10*x^3*(a + b*x))/(3*b^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (10*a^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/b^6 - (10*a^3*(a + b*x)*Log[a + b*x])/(b^6*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{x^4/(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x, 5, -(x^4*(a + b*x))/(2*b*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) - (2*x^3)/(b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (3*x^2*(a + b*x))/(b^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (6*a*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/b^5 + (6*a^2*(a + b*x)*Log[a + b*x])/(b^5*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{x^3/(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x, 4, -(x^3*(a + b*x))/(2*b*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) - (3*x^2)/(2*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (3*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/b^4 - (3*a*(a + b*x)*Log[a + b*x])/(b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{x^2/(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x, 3, -(x^2*(a + b*x))/(2*b*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) - x/(b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + ((a + b*x)*Log[a + b*x])/(b^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{x/(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x, 1, (x^2*(a + b*x))/(2*a*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))}
{(a^2 + 2*a*b*x + b^2*x^2)^(-3/2), x, 1, -(a + b*x)/(2*b*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))}
{1/(x*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)), x, 4, (a + b*x)/(2*a*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + 1/(a^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + ((a + b*x)*Log[x])/(a^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - ((a + b*x)*Log[a + b*x])/(a^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(x^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)), x, 5, (a + b*x)/(2*a*x*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + 3/(2*a^2*x*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (3*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(a^4*x) - (3*b*(a + b*x)*Log[x])/(a^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (3*b*(a + b*x)*Log[a + b*x])/(a^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(x^3*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)), x, 6, (a + b*x)/(2*a*x^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + 2/(a^2*x^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (3*(a + b*x))/(a^3*x^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (6*b*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(a^5*x) + (6*b^2*(a + b*x)*Log[x])/(a^5*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (6*b^2*(a + b*x)*Log[a + b*x])/(a^5*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(x^4*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)), x, 7, (a + b*x)/(2*a*x^3*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + 5/(2*a^2*x^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (10*(a + b*x))/(3*a^3*x^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (5*b*(a + b*x))/(a^4*x^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (10*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(a^6*x) - (10*b^3*(a + b*x)*Log[x])/(a^6*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (10*b^3*(a + b*x)*Log[a + b*x])/(a^6*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}


{x^7/(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 7, -((x^7*(a + b*x))/(4*b*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))) - (7*x^6)/(12*b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) - (7*x^5*(a + b*x))/(4*b^3*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) - (35*x^4)/(4*b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (35*a*x^2*(a + b*x))/(2*b^6*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (35*x^3*(a + b*x))/(3*b^5*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (35*a^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/b^8 - (35*a^3*(a + b*x)*Log[a + b*x])/(b^8*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{x^6/(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 6, -(x^6*(a + b*x))/(4*b*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)) - x^5/(2*b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) - (5*x^4*(a + b*x))/(4*b^3*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) - (5*x^3)/(b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (15*x^2*(a + b*x))/(2*b^5*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (15*a*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/b^7 + (15*a^2*(a + b*x)*Log[a + b*x])/(b^7*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{x^5/(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 5, -(x^5*(a + b*x))/(4*b*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)) - (5*x^4)/(12*b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) - (5*x^3*(a + b*x))/(6*b^3*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) - (5*x^2)/(2*b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (5*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/b^6 - (5*a*(a + b*x)*Log[a + b*x])/(b^6*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{x^4/(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 4, -(x^4*(a + b*x))/(4*b*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)) - x^3/(3*b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) - (x^2*(a + b*x))/(2*b^3*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) - x/(b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + ((a + b*x)*Log[a + b*x])/(b^5*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{x^3/(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 1, (x^4*(a + b*x))/(4*a*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))}
{x^2/(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 1, (x^3*(a + b*x))/(4*a*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)) + x^3/(12*a^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))}
{x/(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 2, (a*(a + b*x))/(4*b^2*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)) - 1/(3*b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))}
{(a^2 + 2*a*b*x + b^2*x^2)^(-5/2), x, 1, -(a + b*x)/(4*b*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))}
{1/(x*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)), x, 5, (a + b*x)/(4*a*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)) + 1/(3*a^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + (a + b*x)/(2*a^3*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + 1/(a^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + ((a + b*x)*Log[x])/(a^5*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - ((a + b*x)*Log[a + b*x])/(a^5*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(x^2*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)), x, 6, (a + b*x)/(4*a*x*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)) + 5/(12*a^2*x*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + (5*(a + b*x))/(6*a^3*x*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + 5/(2*a^4*x*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (5*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(a^6*x) - (5*b*(a + b*x)*Log[x])/(a^6*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (5*b*(a + b*x)*Log[a + b*x])/(a^6*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(x^3*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)), x, 7, (a + b*x)/(4*a*x^2*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)) + 1/(2*a^2*x^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + (5*(a + b*x))/(4*a^3*x^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + 5/(a^4*x^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (15*(a + b*x))/(2*a^5*x^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (15*b*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(a^7*x) + (15*b^2*(a + b*x)*Log[x])/(a^7*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (15*b^2*(a + b*x)*Log[a + b*x])/(a^7*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}


{1/Sqrt[4 + 12*x + 9*x^2], x, 2, ((2 + 3*x)*Log[2 + 3*x])/(3*Sqrt[4 + 12*x + 9*x^2])}
{1/Sqrt[4 - 12*x + 9*x^2], x, 2, -(((2 - 3*x)*Log[2 - 3*x])/(3*Sqrt[4 - 12*x + 9*x^2]))}
{1/Sqrt[-4 + 12*x - 9*x^2], x, 2, -(((2 - 3*x)*Log[2 - 3*x])/(3*Sqrt[-4 + 12*x - 9*x^2]))}
{1/Sqrt[-4 - 12*x - 9*x^2], x, 2, ((2 + 3*x)*Log[2 + 3*x])/(3*Sqrt[-4 - 12*x - 9*x^2])}


{x/Sqrt[4 + 12*x + 9*x^2], x, 3, (1/9)*Sqrt[4 + 12*x + 9*x^2] - (2*(2 + 3*x)*Log[2 + 3*x])/(9*Sqrt[4 + 12*x + 9*x^2])}
{x/Sqrt[4 - 12*x + 9*x^2], x, 3, (1/9)*Sqrt[4 - 12*x + 9*x^2] - (2*(2 - 3*x)*Log[2 - 3*x])/(9*Sqrt[4 - 12*x + 9*x^2])}
{x/Sqrt[-4 + 12*x - 9*x^2], x, 3, (-(1/9))*Sqrt[-4 + 12*x - 9*x^2] - (2*(2 - 3*x)*Log[2 - 3*x])/(9*Sqrt[-4 + 12*x - 9*x^2])}
{x/Sqrt[-4 - 12*x - 9*x^2], x, 3, (-(1/9))*Sqrt[-4 - 12*x - 9*x^2] - (2*(2 + 3*x)*Log[2 + 3*x])/(9*Sqrt[-4 - 12*x - 9*x^2])}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a^2+2 a b x+b^2 x^2)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^(7/2)*(a^2 + 2*a*b*x + b^2*x^2), x, 3, (2*a^2*x^(9/2))/9 + (4*a*b*x^(11/2))/11 + (2*b^2*x^(13/2))/13}
{x^(5/2)*(a^2 + 2*a*b*x + b^2*x^2), x, 3, (2*a^2*x^(7/2))/7 + (4*a*b*x^(9/2))/9 + (2*b^2*x^(11/2))/11}
{x^(3/2)*(a^2 + 2*a*b*x + b^2*x^2), x, 3, (2*a^2*x^(5/2))/5 + (4*a*b*x^(7/2))/7 + (2*b^2*x^(9/2))/9}
{Sqrt[x]*(a^2 + 2*a*b*x + b^2*x^2), x, 3, (2*a^2*x^(3/2))/3 + (4*a*b*x^(5/2))/5 + (2*b^2*x^(7/2))/7}
{(a^2 + 2*a*b*x + b^2*x^2)/Sqrt[x], x, 3, 2*a^2*Sqrt[x] + (4*a*b*x^(3/2))/3 + (2*b^2*x^(5/2))/5}
{(a^2 + 2*a*b*x + b^2*x^2)/x^(3/2), x, 3, (-2*a^2)/Sqrt[x] + 4*a*b*Sqrt[x] + (2*b^2*x^(3/2))/3}
{(a^2 + 2*a*b*x + b^2*x^2)/x^(5/2), x, 3, (-2*a^2)/(3*x^(3/2)) - (4*a*b)/Sqrt[x] + 2*b^2*Sqrt[x]}
{(a^2 + 2*a*b*x + b^2*x^2)/x^(7/2), x, 3, (-2*a^2)/(5*x^(5/2)) - (4*a*b)/(3*x^(3/2)) - (2*b^2)/Sqrt[x]}


{x^(7/2)*(a^2 + 2*a*b*x + b^2*x^2)^2, x, 3, (2*a^4*x^(9/2))/9 + (8*a^3*b*x^(11/2))/11 + (12*a^2*b^2*x^(13/2))/13 + (8*a*b^3*x^(15/2))/15 + (2*b^4*x^(17/2))/17}
{x^(5/2)*(a^2 + 2*a*b*x + b^2*x^2)^2, x, 3, (2*a^4*x^(7/2))/7 + (8*a^3*b*x^(9/2))/9 + (12*a^2*b^2*x^(11/2))/11 + (8*a*b^3*x^(13/2))/13 + (2*b^4*x^(15/2))/15}
{x^(3/2)*(a^2 + 2*a*b*x + b^2*x^2)^2, x, 3, (2*a^4*x^(5/2))/5 + (8*a^3*b*x^(7/2))/7 + (4*a^2*b^2*x^(9/2))/3 + (8*a*b^3*x^(11/2))/11 + (2*b^4*x^(13/2))/13}
{Sqrt[x]*(a^2 + 2*a*b*x + b^2*x^2)^2, x, 3, (2*a^4*x^(3/2))/3 + (8*a^3*b*x^(5/2))/5 + (12*a^2*b^2*x^(7/2))/7 + (8*a*b^3*x^(9/2))/9 + (2*b^4*x^(11/2))/11}
{(a^2 + 2*a*b*x + b^2*x^2)^2/Sqrt[x], x, 3, 2*a^4*Sqrt[x] + (8*a^3*b*x^(3/2))/3 + (12*a^2*b^2*x^(5/2))/5 + (8*a*b^3*x^(7/2))/7 + (2*b^4*x^(9/2))/9}
{(a^2 + 2*a*b*x + b^2*x^2)^2/x^(3/2), x, 3, (-2*a^4)/Sqrt[x] + 8*a^3*b*Sqrt[x] + 4*a^2*b^2*x^(3/2) + (8*a*b^3*x^(5/2))/5 + (2*b^4*x^(7/2))/7}
{(a^2 + 2*a*b*x + b^2*x^2)^2/x^(5/2), x, 3, (-2*a^4)/(3*x^(3/2)) - (8*a^3*b)/Sqrt[x] + 12*a^2*b^2*Sqrt[x] + (8*a*b^3*x^(3/2))/3 + (2*b^4*x^(5/2))/5}
{(a^2 + 2*a*b*x + b^2*x^2)^2/x^(7/2), x, 3, (-2*a^4)/(5*x^(5/2)) - (8*a^3*b)/(3*x^(3/2)) - (12*a^2*b^2)/Sqrt[x] + 8*a*b^3*Sqrt[x] + (2*b^4*x^(3/2))/3}


{x^(7/2)*(a^2 + 2*a*b*x + b^2*x^2)^3, x, 3, (2*a^6*x^(9/2))/9 + (12*a^5*b*x^(11/2))/11 + (30*a^4*b^2*x^(13/2))/13 + (8*a^3*b^3*x^(15/2))/3 + (30*a^2*b^4*x^(17/2))/17 + (12*a*b^5*x^(19/2))/19 + (2*b^6*x^(21/2))/21}
{x^(5/2)*(a^2 + 2*a*b*x + b^2*x^2)^3, x, 3, (2*a^6*x^(7/2))/7 + (4*a^5*b*x^(9/2))/3 + (30*a^4*b^2*x^(11/2))/11 + (40*a^3*b^3*x^(13/2))/13 + 2*a^2*b^4*x^(15/2) + (12*a*b^5*x^(17/2))/17 + (2*b^6*x^(19/2))/19}
{x^(3/2)*(a^2 + 2*a*b*x + b^2*x^2)^3, x, 3, (2*a^6*x^(5/2))/5 + (12*a^5*b*x^(7/2))/7 + (10*a^4*b^2*x^(9/2))/3 + (40*a^3*b^3*x^(11/2))/11 + (30*a^2*b^4*x^(13/2))/13 + (4*a*b^5*x^(15/2))/5 + (2*b^6*x^(17/2))/17}
{Sqrt[x]*(a^2 + 2*a*b*x + b^2*x^2)^3, x, 3, (2*a^6*x^(3/2))/3 + (12*a^5*b*x^(5/2))/5 + (30*a^4*b^2*x^(7/2))/7 + (40*a^3*b^3*x^(9/2))/9 + (30*a^2*b^4*x^(11/2))/11 + (12*a*b^5*x^(13/2))/13 + (2*b^6*x^(15/2))/15}
{(a^2 + 2*a*b*x + b^2*x^2)^3/Sqrt[x], x, 3, 2*a^6*Sqrt[x] + 4*a^5*b*x^(3/2) + 6*a^4*b^2*x^(5/2) + (40*a^3*b^3*x^(7/2))/7 + (10*a^2*b^4*x^(9/2))/3 + (12*a*b^5*x^(11/2))/11 + (2*b^6*x^(13/2))/13}
{(a^2 + 2*a*b*x + b^2*x^2)^3/x^(3/2), x, 3, (-2*a^6)/Sqrt[x] + 12*a^5*b*Sqrt[x] + 10*a^4*b^2*x^(3/2) + 8*a^3*b^3*x^(5/2) + (30*a^2*b^4*x^(7/2))/7 + (4*a*b^5*x^(9/2))/3 + (2*b^6*x^(11/2))/11}
{(a^2 + 2*a*b*x + b^2*x^2)^3/x^(5/2), x, 3, (-2*a^6)/(3*x^(3/2)) - (12*a^5*b)/Sqrt[x] + 30*a^4*b^2*Sqrt[x] + (40*a^3*b^3*x^(3/2))/3 + 6*a^2*b^4*x^(5/2) + (12*a*b^5*x^(7/2))/7 + (2*b^6*x^(9/2))/9}
{(a^2 + 2*a*b*x + b^2*x^2)^3/x^(7/2), x, 3, (-2*a^6)/(5*x^(5/2)) - (4*a^5*b)/x^(3/2) - (30*a^4*b^2)/Sqrt[x] + 40*a^3*b^3*Sqrt[x] + 10*a^2*b^4*x^(3/2) + (12*a*b^5*x^(5/2))/5 + (2*b^6*x^(7/2))/7}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^(9/2)/(a^2 + 2*a*b*x + b^2*x^2), x, 7, (-9*a^3*Sqrt[x])/b^5 + (3*a^2*x^(3/2))/b^4 - (9*a*x^(5/2))/(5*b^3) + (9*x^(7/2))/(7*b^2) - x^(9/2)/(b*(a + b*x)) + (9*a^(7/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/b^(11/2)}
{x^(7/2)/(a^2 + 2*a*b*x + b^2*x^2), x, 6, (7*a^2*Sqrt[x])/b^4 - (7*a*x^(3/2))/(3*b^3) + (7*x^(5/2))/(5*b^2) - x^(7/2)/(b*(a + b*x)) - (7*a^(5/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/b^(9/2)}
{x^(5/2)/(a^2 + 2*a*b*x + b^2*x^2), x, 5, (-5*a*Sqrt[x])/b^3 + (5*x^(3/2))/(3*b^2) - x^(5/2)/(b*(a + b*x)) + (5*a^(3/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/b^(7/2)}
{x^(3/2)/(a^2 + 2*a*b*x + b^2*x^2), x, 4, (3*Sqrt[x])/b^2 - x^(3/2)/(b*(a + b*x)) - (3*Sqrt[a]*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/b^(5/2)}
{Sqrt[x]/(a^2 + 2*a*b*x + b^2*x^2), x, 3, -(Sqrt[x]/(b*(a + b*x))) + ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]]/(Sqrt[a]*b^(3/2))}
{1/(Sqrt[x]*(a^2 + 2*a*b*x + b^2*x^2)), x, 3, Sqrt[x]/(a*(a + b*x)) + ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]]/(a^(3/2)*Sqrt[b])}
{1/(x^(3/2)*(a^2 + 2*a*b*x + b^2*x^2)), x, 4, -3/(a^2*Sqrt[x]) + 1/(a*Sqrt[x]*(a + b*x)) - (3*Sqrt[b]*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/a^(5/2)}
{1/(x^(5/2)*(a^2 + 2*a*b*x + b^2*x^2)), x, 5, -5/(3*a^2*x^(3/2)) + (5*b)/(a^3*Sqrt[x]) + 1/(a*x^(3/2)*(a + b*x)) + (5*b^(3/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/a^(7/2)}
{1/(x^(7/2)*(a^2 + 2*a*b*x + b^2*x^2)), x, 6, -7/(5*a^2*x^(5/2)) + (7*b)/(3*a^3*x^(3/2)) - (7*b^2)/(a^4*Sqrt[x]) + 1/(a*x^(5/2)*(a + b*x)) - (7*b^(5/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/a^(9/2)}


{x^(11/2)/(a^2 + 2*a*b*x + b^2*x^2)^2, x, 8, (231*a^2*Sqrt[x])/(8*b^6) - (77*a*x^(3/2))/(8*b^5) + (231*x^(5/2))/(40*b^4) - x^(11/2)/(3*b*(a + b*x)^3) - (11*x^(9/2))/(12*b^2*(a + b*x)^2) - (33*x^(7/2))/(8*b^3*(a + b*x)) - (231*a^(5/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(8*b^(13/2))}
{x^(9/2)/(a^2 + 2*a*b*x + b^2*x^2)^2, x, 7, (-105*a*Sqrt[x])/(8*b^5) + (35*x^(3/2))/(8*b^4) - x^(9/2)/(3*b*(a + b*x)^3) - (3*x^(7/2))/(4*b^2*(a + b*x)^2) - (21*x^(5/2))/(8*b^3*(a + b*x)) + (105*a^(3/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(8*b^(11/2))}
{x^(7/2)/(a^2 + 2*a*b*x + b^2*x^2)^2, x, 6, (35*Sqrt[x])/(8*b^4) - x^(7/2)/(3*b*(a + b*x)^3) - (7*x^(5/2))/(12*b^2*(a + b*x)^2) - (35*x^(3/2))/(24*b^3*(a + b*x)) - (35*Sqrt[a]*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(8*b^(9/2))}
{x^(5/2)/(a^2 + 2*a*b*x + b^2*x^2)^2, x, 5, -x^(5/2)/(3*b*(a + b*x)^3) - (5*x^(3/2))/(12*b^2*(a + b*x)^2) - (5*Sqrt[x])/(8*b^3*(a + b*x)) + (5*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(8*Sqrt[a]*b^(7/2))}
{x^(3/2)/(a^2 + 2*a*b*x + b^2*x^2)^2, x, 5, -x^(3/2)/(3*b*(a + b*x)^3) - Sqrt[x]/(4*b^2*(a + b*x)^2) + Sqrt[x]/(8*a*b^2*(a + b*x)) + ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]]/(8*a^(3/2)*b^(5/2))}
{Sqrt[x]/(a^2 + 2*a*b*x + b^2*x^2)^2, x, 5, -Sqrt[x]/(3*b*(a + b*x)^3) + Sqrt[x]/(12*a*b*(a + b*x)^2) + Sqrt[x]/(8*a^2*b*(a + b*x)) + ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]]/(8*a^(5/2)*b^(3/2))}
{1/(Sqrt[x]*(a^2 + 2*a*b*x + b^2*x^2)^2), x, 5, Sqrt[x]/(3*a*(a + b*x)^3) + (5*Sqrt[x])/(12*a^2*(a + b*x)^2) + (5*Sqrt[x])/(8*a^3*(a + b*x)) + (5*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(8*a^(7/2)*Sqrt[b])}
{1/(x^(3/2)*(a^2 + 2*a*b*x + b^2*x^2)^2), x, 6, -35/(8*a^4*Sqrt[x]) + 1/(3*a*Sqrt[x]*(a + b*x)^3) + 7/(12*a^2*Sqrt[x]*(a + b*x)^2) + 35/(24*a^3*Sqrt[x]*(a + b*x)) - (35*Sqrt[b]*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(8*a^(9/2))}
{1/(x^(5/2)*(a^2 + 2*a*b*x + b^2*x^2)^2), x, 7, -35/(8*a^4*x^(3/2)) + (105*b)/(8*a^5*Sqrt[x]) + 1/(3*a*x^(3/2)*(a + b*x)^3) + 3/(4*a^2*x^(3/2)*(a + b*x)^2) + 21/(8*a^3*x^(3/2)*(a + b*x)) + (105*b^(3/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(8*a^(11/2))}
{1/(x^(7/2)*(a^2 + 2*a*b*x + b^2*x^2)^2), x, 8, -231/(40*a^4*x^(5/2)) + (77*b)/(8*a^5*x^(3/2)) - (231*b^2)/(8*a^6*Sqrt[x]) + 1/(3*a*x^(5/2)*(a + b*x)^3) + 11/(12*a^2*x^(5/2)*(a + b*x)^2) + 33/(8*a^3*x^(5/2)*(a + b*x)) - (231*b^(5/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(8*a^(13/2))}


{x^(15/2)/(a^2 + 2*a*b*x + b^2*x^2)^3, x, 10, (9009*a^2*Sqrt[x])/(128*b^8) - (3003*a*x^(3/2))/(128*b^7) + (9009*x^(5/2))/(640*b^6) - x^(15/2)/(5*b*(a + b*x)^5) - (3*x^(13/2))/(8*b^2*(a + b*x)^4) - (13*x^(11/2))/(16*b^3*(a + b*x)^3) - (143*x^(9/2))/(64*b^4*(a + b*x)^2) - (1287*x^(7/2))/(128*b^5*(a + b*x)) - (9009*a^(5/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(128*b^(17/2))}
{x^(13/2)/(a^2 + 2*a*b*x + b^2*x^2)^3, x, 9, (-3003*a*Sqrt[x])/(128*b^7) + (1001*x^(3/2))/(128*b^6) - x^(13/2)/(5*b*(a + b*x)^5) - (13*x^(11/2))/(40*b^2*(a + b*x)^4) - (143*x^(9/2))/(240*b^3*(a + b*x)^3) - (429*x^(7/2))/(320*b^4*(a + b*x)^2) - (3003*x^(5/2))/(640*b^5*(a + b*x)) + (3003*a^(3/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(128*b^(15/2))}
{x^(11/2)/(a^2 + 2*a*b*x + b^2*x^2)^3, x, 8, (693*Sqrt[x])/(128*b^6) - x^(11/2)/(5*b*(a + b*x)^5) - (11*x^(9/2))/(40*b^2*(a + b*x)^4) - (33*x^(7/2))/(80*b^3*(a + b*x)^3) - (231*x^(5/2))/(320*b^4*(a + b*x)^2) - (231*x^(3/2))/(128*b^5*(a + b*x)) - (693*Sqrt[a]*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(128*b^(13/2))}
{x^(9/2)/(a^2 + 2*a*b*x + b^2*x^2)^3, x, 7, -x^(9/2)/(5*b*(a + b*x)^5) - (9*x^(7/2))/(40*b^2*(a + b*x)^4) - (21*x^(5/2))/(80*b^3*(a + b*x)^3) - (21*x^(3/2))/(64*b^4*(a + b*x)^2) - (63*Sqrt[x])/(128*b^5*(a + b*x)) + (63*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(128*Sqrt[a]*b^(11/2))}
{x^(7/2)/(a^2 + 2*a*b*x + b^2*x^2)^3, x, 7, -x^(7/2)/(5*b*(a + b*x)^5) - (7*x^(5/2))/(40*b^2*(a + b*x)^4) - (7*x^(3/2))/(48*b^3*(a + b*x)^3) - (7*Sqrt[x])/(64*b^4*(a + b*x)^2) + (7*Sqrt[x])/(128*a*b^4*(a + b*x)) + (7*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(128*a^(3/2)*b^(9/2))}
{x^(5/2)/(a^2 + 2*a*b*x + b^2*x^2)^3, x, 7, -x^(5/2)/(5*b*(a + b*x)^5) - x^(3/2)/(8*b^2*(a + b*x)^4) - Sqrt[x]/(16*b^3*(a + b*x)^3) + Sqrt[x]/(64*a*b^3*(a + b*x)^2) + (3*Sqrt[x])/(128*a^2*b^3*(a + b*x)) + (3*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(128*a^(5/2)*b^(7/2))}
{x^(3/2)/(a^2 + 2*a*b*x + b^2*x^2)^3, x, 7, -x^(3/2)/(5*b*(a + b*x)^5) - (3*Sqrt[x])/(40*b^2*(a + b*x)^4) + Sqrt[x]/(80*a*b^2*(a + b*x)^3) + Sqrt[x]/(64*a^2*b^2*(a + b*x)^2) + (3*Sqrt[x])/(128*a^3*b^2*(a + b*x)) + (3*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(128*a^(7/2)*b^(5/2))}
{Sqrt[x]/(a^2 + 2*a*b*x + b^2*x^2)^3, x, 7, -Sqrt[x]/(5*b*(a + b*x)^5) + Sqrt[x]/(40*a*b*(a + b*x)^4) + (7*Sqrt[x])/(240*a^2*b*(a + b*x)^3) + (7*Sqrt[x])/(192*a^3*b*(a + b*x)^2) + (7*Sqrt[x])/(128*a^4*b*(a + b*x)) + (7*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(128*a^(9/2)*b^(3/2))}
{1/(Sqrt[x]*(a^2 + 2*a*b*x + b^2*x^2)^3), x, 7, Sqrt[x]/(5*a*(a + b*x)^5) + (9*Sqrt[x])/(40*a^2*(a + b*x)^4) + (21*Sqrt[x])/(80*a^3*(a + b*x)^3) + (21*Sqrt[x])/(64*a^4*(a + b*x)^2) + (63*Sqrt[x])/(128*a^5*(a + b*x)) + (63*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(128*a^(11/2)*Sqrt[b])}
{1/(x^(3/2)*(a^2 + 2*a*b*x + b^2*x^2)^3), x, 8, -693/(128*a^6*Sqrt[x]) + 1/(5*a*Sqrt[x]*(a + b*x)^5) + 11/(40*a^2*Sqrt[x]*(a + b*x)^4) + 33/(80*a^3*Sqrt[x]*(a + b*x)^3) + 231/(320*a^4*Sqrt[x]*(a + b*x)^2) + 231/(128*a^5*Sqrt[x]*(a + b*x)) - (693*Sqrt[b]*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(128*a^(13/2))}
{1/(x^(5/2)*(a^2 + 2*a*b*x + b^2*x^2)^3), x, 9, -1001/(128*a^6*x^(3/2)) + (3003*b)/(128*a^7*Sqrt[x]) + 1/(5*a*x^(3/2)*(a + b*x)^5) + 13/(40*a^2*x^(3/2)*(a + b*x)^4) + 143/(240*a^3*x^(3/2)*(a + b*x)^3) + 429/(320*a^4*x^(3/2)*(a + b*x)^2) + 3003/(640*a^5*x^(3/2)*(a + b*x)) + (3003*b^(3/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(128*a^(15/2))}
{1/(x^(7/2)*(a^2 + 2*a*b*x + b^2*x^2)^3), x, 10, -9009/(640*a^6*x^(5/2)) + (3003*b)/(128*a^7*x^(3/2)) - (9009*b^2)/(128*a^8*Sqrt[x]) + 1/(5*a*x^(5/2)*(a + b*x)^5) + 3/(8*a^2*x^(5/2)*(a + b*x)^4) + 13/(16*a^3*x^(5/2)*(a + b*x)^3) + 143/(64*a^4*x^(5/2)*(a + b*x)^2) + 1287/(128*a^5*x^(5/2)*(a + b*x)) - (9009*b^(5/2)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(128*a^(17/2))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a^2+2 a b x+b^2 x^2)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^(7/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2], x, 2, (2/11)*x^(9/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (4*a*x^(9/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(99*(a + b*x))}
{x^(5/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2], x, 2, (2/9)*x^(7/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (4*a*x^(7/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(63*(a + b*x))}
{x^(3/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2], x, 2, (2/7)*x^(5/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (4*a*x^(5/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(35*(a + b*x))}
{Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2], x, 2, (2/5)*x^(3/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (4*a*x^(3/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(15*(a + b*x))}
{Sqrt[a^2 + 2*a*b*x + b^2*x^2]/Sqrt[x], x, 2, (2/3)*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (4*a*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(3*(a + b*x))}
{Sqrt[a^2 + 2*a*b*x + b^2*x^2]/x^(3/2), x, 2, (2*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/Sqrt[x] - (4*a*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(Sqrt[x]*(a + b*x))}
{Sqrt[a^2 + 2*a*b*x + b^2*x^2]/x^(5/2), x, 2, -((2*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/x^(3/2)) + (4*a*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(3*x^(3/2)*(a + b*x))}
{Sqrt[a^2 + 2*a*b*x + b^2*x^2]/x^(7/2), x, 2, -((2*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(3*x^(5/2))) + (4*a*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(15*x^(5/2)*(a + b*x))}


{x^(7/2)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x, 3, (16/715)*a^2*x^(9/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (32*a^3*x^(9/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(6435*(a + b*x)) + (4/65)*a*x^(9/2)*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (2/15)*x^(9/2)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)}
{x^(5/2)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x, 3, (16/429)*a^2*x^(7/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (32*a^3*x^(7/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(3003*(a + b*x)) + (12/143)*a*x^(7/2)*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (2/13)*x^(7/2)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)}
{x^(3/2)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x, 3, (16/231)*a^2*x^(5/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (32*a^3*x^(5/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(1155*(a + b*x)) + (4/33)*a*x^(5/2)*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (2/11)*x^(5/2)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)}
{Sqrt[x]*(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x, 3, (16/105)*a^2*x^(3/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (32*a^3*x^(3/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(315*(a + b*x)) + (4/21)*a*x^(3/2)*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (2/9)*x^(3/2)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)}
{(a^2 + 2*a*b*x + b^2*x^2)^(3/2)/Sqrt[x], x, 3, (16/35)*a^2*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (32*a^3*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(35*(a + b*x)) + (12/35)*a*Sqrt[x]*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (2/7)*Sqrt[x]*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)}
{(a^2 + 2*a*b*x + b^2*x^2)^(3/2)/x^(3/2), x, 3, (16/5)*a*b*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (32*a^2*b*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(5*(a + b*x)) + (12/5)*b*Sqrt[x]*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] - (2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/Sqrt[x]}
{(a^2 + 2*a*b*x + b^2*x^2)^(3/2)/x^(5/2), x, 3, (16/3)*b^2*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (32*a*b^2*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(3*(a + b*x)) - (4*b*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/Sqrt[x] - (2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(3*x^(3/2))}
{(a^2 + 2*a*b*x + b^2*x^2)^(3/2)/x^(7/2), x, 3, (16*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(5*Sqrt[x]) - (32*a*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(5*Sqrt[x]*(a + b*x)) - (4*b*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(5*x^(3/2)) - (2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(5*x^(5/2))}


{x^(7/2)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 4, (256*a^4*x^(9/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/46189 + (512*a^5*x^(9/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(415701*(a + b*x)) + (64*a^3*x^(9/2)*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/4199 + (32/969)*a^2*x^(9/2)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) + (20/323)*a*x^(9/2)*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) + (2/19)*x^(9/2)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)}
{x^(5/2)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 4, (256*a^4*x^(7/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/21879 + (512*a^5*x^(7/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(153153*(a + b*x)) + (64*a^3*x^(7/2)*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/2431 + (32/663)*a^2*x^(7/2)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) + (4/51)*a*x^(7/2)*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) + (2/17)*x^(7/2)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)}
{x^(3/2)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 4, (256*a^4*x^(5/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/9009 + (512*a^5*x^(5/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(45045*(a + b*x)) + (64*a^3*x^(5/2)*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/1287 + (32/429)*a^2*x^(5/2)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) + (4/39)*a*x^(5/2)*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) + (2/15)*x^(5/2)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)}
{Sqrt[x]*(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 4, (256*a^4*x^(3/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/3003 + (512*a^5*x^(3/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(9009*(a + b*x)) + (320*a^3*x^(3/2)*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/3003 + (160*a^2*x^(3/2)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/1287 + (20/143)*a*x^(3/2)*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) + (2/13)*x^(3/2)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)}
{(a^2 + 2*a*b*x + b^2*x^2)^(5/2)/Sqrt[x], x, 4, (256/693)*a^4*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (512*a^5*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(693*(a + b*x)) + (64/231)*a^3*Sqrt[x]*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (160/693)*a^2*Sqrt[x]*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) + (20/99)*a*Sqrt[x]*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) + (2/11)*Sqrt[x]*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)}
{(a^2 + 2*a*b*x + b^2*x^2)^(5/2)/x^(3/2), x, 4, (256/63)*a^3*b*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (512*a^4*b*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(63*(a + b*x)) + (64/21)*a^2*b*Sqrt[x]*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (160/63)*a*b*Sqrt[x]*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) + (20/9)*b*Sqrt[x]*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) - (2*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/Sqrt[x]}
{(a^2 + 2*a*b*x + b^2*x^2)^(5/2)/x^(5/2), x, 4, (256/21)*a^2*b^2*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (512*a^3*b^2*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(21*(a + b*x)) + (64/7)*a*b^2*Sqrt[x]*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (160/21)*b^2*Sqrt[x]*(a^2 + 2*a*b*x + b^2*x^2)^(3/2) - (20*b*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(3*Sqrt[x]) - (2*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(3*x^(3/2))}
{(a^2 + 2*a*b*x + b^2*x^2)^(5/2)/x^(7/2), x, 4, (256/15)*a*b^3*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2] + (512*a^2*b^3*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(15*(a + b*x)) + (64/5)*b^3*Sqrt[x]*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2] - (32*b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(3*Sqrt[x]) - (4*b*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(3*x^(3/2)) - (2*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(5*x^(5/2))}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^(7/2)/Sqrt[a^2 + 2*a*b*x + b^2*x^2], x, 6, -((2*a^3*Sqrt[x]*(a + b*x))/(b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2])) + (2*a^2*x^(3/2)*(a + b*x))/(3*b^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (2*a*x^(5/2)*(a + b*x))/(5*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (2*x^(7/2)*(a + b*x))/(7*b*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (2*a^(7/2)*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(b^(9/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{x^(5/2)/Sqrt[a^2 + 2*a*b*x + b^2*x^2], x, 5, (2*a^2*Sqrt[x]*(a + b*x))/(b^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (2*a*x^(3/2)*(a + b*x))/(3*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (2*x^(5/2)*(a + b*x))/(5*b*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (2*a^(5/2)*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(b^(7/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{x^(3/2)/Sqrt[a^2 + 2*a*b*x + b^2*x^2], x, 4, -((2*a*Sqrt[x]*(a + b*x))/(b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2])) + (2*x^(3/2)*(a + b*x))/(3*b*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (2*a^(3/2)*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(b^(5/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{Sqrt[x]/Sqrt[a^2 + 2*a*b*x + b^2*x^2], x, 3, (2*Sqrt[x]*(a + b*x))/(b*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (2*Sqrt[a]*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(b^(3/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2]), x, 2, (2*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(Sqrt[a]*Sqrt[b]*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(x^(3/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2]), x, 3, -((2*(a + b*x))/(a*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2])) - (2*Sqrt[b]*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(a^(3/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(x^(5/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2]), x, 4, -((2*(a + b*x))/(3*a*x^(3/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])) + (2*b*(a + b*x))/(a^2*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (2*b^(3/2)*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(a^(5/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(x^(7/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2]), x, 5, -((2*(a + b*x))/(5*a*x^(5/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])) + (2*b*(a + b*x))/(3*a^2*x^(3/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (2*b^2*(a + b*x))/(a^3*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (2*b^(5/2)*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(a^(7/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}


{x^(9/2)/(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x, 6, -((x^(9/2)*(a + b*x))/(2*b*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))) - (9*x^(7/2))/(4*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (63*a^2*Sqrt[x]*(a + b*x))/(4*b^5*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (21*a*x^(3/2)*(a + b*x))/(4*b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (63*x^(5/2)*(a + b*x))/(20*b^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (63*a^(5/2)*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(4*b^(11/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{x^(7/2)/(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x, 5, -((x^(7/2)*(a + b*x))/(2*b*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))) - (7*x^(5/2))/(4*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (35*a*Sqrt[x]*(a + b*x))/(4*b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (35*x^(3/2)*(a + b*x))/(12*b^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (35*a^(3/2)*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(4*b^(9/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{x^(5/2)/(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x, 4, -((x^(5/2)*(a + b*x))/(2*b*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))) - (5*x^(3/2))/(4*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (15*Sqrt[x]*(a + b*x))/(4*b^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (15*Sqrt[a]*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(4*b^(7/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{x^(3/2)/(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x, 3, -((x^(3/2)*(a + b*x))/(2*b*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))) - (3*Sqrt[x])/(4*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (3*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(4*Sqrt[a]*b^(5/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{Sqrt[x]/(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x, 3, (x^(3/2)*(a + b*x))/(2*a*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) - Sqrt[x]/(4*a*b*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + ((a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(4*a^(3/2)*b^(3/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(Sqrt[x]*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)), x, 3, (Sqrt[x]*(a + b*x))/(2*a*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + (3*Sqrt[x])/(4*a^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (3*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(4*a^(5/2)*Sqrt[b]*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(x^(3/2)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)), x, 4, (a + b*x)/(2*a*Sqrt[x]*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + 5/(4*a^2*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (15*(a + b*x))/(4*a^3*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (15*Sqrt[b]*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(4*a^(7/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(x^(5/2)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)), x, 5, (a + b*x)/(2*a*x^(3/2)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + 7/(4*a^2*x^(3/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (35*(a + b*x))/(12*a^3*x^(3/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (35*b*(a + b*x))/(4*a^4*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (35*b^(3/2)*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(4*a^(9/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(x^(7/2)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)), x, 6, (a + b*x)/(2*a*x^(5/2)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + 9/(4*a^2*x^(5/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (63*(a + b*x))/(20*a^3*x^(5/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (21*b*(a + b*x))/(4*a^4*x^(3/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (63*b^2*(a + b*x))/(4*a^5*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (63*b^(5/2)*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(4*a^(11/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}


{x^(13/2)/(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 7, -((x^(13/2)*(a + b*x))/(4*b*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))) - (13*x^(11/2))/(24*b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) - (143*x^(9/2)*(a + b*x))/(96*b^3*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) - (429*x^(7/2))/(64*b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (3003*a^2*Sqrt[x]*(a + b*x))/(64*b^7*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (1001*a*x^(3/2)*(a + b*x))/(64*b^6*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (3003*x^(5/2)*(a + b*x))/(320*b^5*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (3003*a^(5/2)*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(64*b^(15/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{x^(11/2)/(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 6, -((x^(11/2)*(a + b*x))/(4*b*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))) - (11*x^(9/2))/(24*b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) - (33*x^(7/2)*(a + b*x))/(32*b^3*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) - (231*x^(5/2))/(64*b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (1155*a*Sqrt[x]*(a + b*x))/(64*b^6*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (385*x^(3/2)*(a + b*x))/(64*b^5*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (1155*a^(3/2)*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(64*b^(13/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{x^(9/2)/(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 5, -((x^(9/2)*(a + b*x))/(4*b*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))) - (3*x^(7/2))/(8*b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) - (21*x^(5/2)*(a + b*x))/(32*b^3*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) - (105*x^(3/2))/(64*b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (315*Sqrt[x]*(a + b*x))/(64*b^5*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (315*Sqrt[a]*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(64*b^(11/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{x^(7/2)/(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 4, -((x^(7/2)*(a + b*x))/(4*b*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))) - (7*x^(5/2))/(24*b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) - (35*x^(3/2)*(a + b*x))/(96*b^3*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) - (35*Sqrt[x])/(64*b^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (35*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(64*Sqrt[a]*b^(9/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{x^(5/2)/(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 4, -((x^(5/2)*(a + b*x))/(4*b*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))) - (5*x^(3/2))/(24*b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + (5*x^(3/2)*(a + b*x))/(32*a*b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) - (5*Sqrt[x])/(64*a*b^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (5*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(64*a^(3/2)*b^(7/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{x^(3/2)/(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 4, -((x^(3/2)*(a + b*x))/(4*b*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))) - Sqrt[x]/(8*b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + (Sqrt[x]*(a + b*x))/(32*a*b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + (3*Sqrt[x])/(64*a^2*b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (3*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(64*a^(5/2)*b^(5/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{Sqrt[x]/(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x, 4, (x^(3/2)*(a + b*x))/(4*a*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)) - (5*Sqrt[x])/(24*a*b*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + (5*Sqrt[x]*(a + b*x))/(96*a^2*b*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + (5*Sqrt[x])/(64*a^3*b*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (5*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(64*a^(7/2)*b^(3/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(Sqrt[x]*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)), x, 4, (Sqrt[x]*(a + b*x))/(4*a*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)) + (7*Sqrt[x])/(24*a^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + (35*Sqrt[x]*(a + b*x))/(96*a^3*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + (35*Sqrt[x])/(64*a^4*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (35*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(64*a^(9/2)*Sqrt[b]*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(x^(3/2)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)), x, 5, (a + b*x)/(4*a*Sqrt[x]*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)) + 3/(8*a^2*Sqrt[x]*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + (21*(a + b*x))/(32*a^3*Sqrt[x]*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + 105/(64*a^4*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (315*(a + b*x))/(64*a^5*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (315*Sqrt[b]*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(64*a^(11/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(x^(5/2)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)), x, 6, (a + b*x)/(4*a*x^(3/2)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)) + 11/(24*a^2*x^(3/2)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + (33*(a + b*x))/(32*a^3*x^(3/2)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + 231/(64*a^4*x^(3/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (385*(a + b*x))/(64*a^5*x^(3/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (1155*b*(a + b*x))/(64*a^6*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (1155*b^(3/2)*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(64*a^(13/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(x^(7/2)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)), x, 7, (a + b*x)/(4*a*x^(5/2)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2)) + 13/(24*a^2*x^(5/2)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + (143*(a + b*x))/(96*a^3*x^(5/2)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + 429/(64*a^4*x^(5/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (3003*(a + b*x))/(320*a^5*x^(5/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) + (1001*b*(a + b*x))/(64*a^6*x^(3/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (3003*b^2*(a + b*x))/(64*a^7*Sqrt[x]*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - (3003*b^(5/2)*(a + b*x)*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(64*a^(15/2)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a^2+2 a b x+b^2 x^2)^p when p is symbolic*)


{x^3*(a^2 + 2*a*b*x + b^2*x^2)^p, x, 4, -((3*a^3*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^p)/(b^4*(2 + p)*(3 + 8*p + 4*p^2))) - (3*a*x^2*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^p)/(2*b^2*(2 + p)*(3 + 2*p)) + (x^3*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^p)/(2*b*(2 + p)) + (3*a^2*(a^2 + 2*a*b*x + b^2*x^2)^(1 + p))/(2*b^4*(1 + p)*(2 + p)*(3 + 2*p))}
{x^2*(a^2 + 2*a*b*x + b^2*x^2)^p, x, 3, (2*a^2*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^p)/(b^3*(3 + 8*p + 4*p^2)) + (x^2*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^p)/(b*(3 + 2*p)) - (a*(a^2 + 2*a*b*x + b^2*x^2)^(1 + p))/(b^3*(1 + p)*(3 + 2*p))}
{x^1*(a^2 + 2*a*b*x + b^2*x^2)^p, x, 2, -((a*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^p)/(b^2*(1 + 2*p))) + (a^2 + 2*a*b*x + b^2*x^2)^(1 + p)/(2*b^2*(1 + p))}
{x^0*(a^2 + 2*a*b*x + b^2*x^2)^p, x, 1, ((a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^p)/(b*(1 + 2*p))}
{(a^2 + 2*a*b*x + b^2*x^2)^p/x^1, x, 2, -(((a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^p*Hypergeometric2F1[1, 1 + 2*p, 2*(1 + p), (a + b*x)/a])/(a*(1 + 2*p)))}
{(a^2 + 2*a*b*x + b^2*x^2)^p/x^2, x, 3, -(((a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^p)/(a*x)) - (2*b*p*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^p*Hypergeometric2F1[1, 1 + 2*p, 2*(1 + p), (a + b*x)/a])/(a^2*(1 + 2*p))}
{(a^2 + 2*a*b*x + b^2*x^2)^p/x^3, x, 4, -(((a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^p)/(2*a*x^2)) + (b*(1 - 2*p)*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^p)/(2*a^2*x) + (b^2*(1 - 2*p)*p*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^p*Hypergeometric2F1[1, 1 + 2*p, 2*(1 + p), (a + b*x)/a])/(a^3*(1 + 2*p))}


(* ::Section:: *)
(*Integrands of the form x^m (a+b x+c x^2)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x+c x^2)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^m*(a + b*x + c*x^2), x, 2, (a*x^(1 + m))/(1 + m) + (b*x^(2 + m))/(2 + m) + (c*x^(3 + m))/(3 + m)}

{x^4*(a + b*x + c*x^2), x, 2, (a*x^5)/5 + (b*x^6)/6 + (c*x^7)/7}
{x^3*(a + b*x + c*x^2), x, 2, (a*x^4)/4 + (b*x^5)/5 + (c*x^6)/6}
{x^2*(a + b*x + c*x^2), x, 2, (a*x^3)/3 + (b*x^4)/4 + (c*x^5)/5}
{x^1*(a + b*x + c*x^2), x, 2, (a*x^2)/2 + (b*x^3)/3 + (c*x^4)/4}
{x^0*(a + b*x + c*x^2), x, 1, a*x + (b*x^2)/2 + (c*x^3)/3}
{(a + b*x + c*x^2)/x^1, x, 2, b*x + (c*x^2)/2 + a*Log[x]}
{(a + b*x + c*x^2)/x^2, x, 2, -(a/x) + c*x + b*Log[x]}
{(a + b*x + c*x^2)/x^3, x, 2, -(a/(2*x^2)) - b/x + c*Log[x]}
{(a + b*x + c*x^2)/x^4, x, 2, -(a/(3*x^3)) - b/(2*x^2) - c/x}
{(a + b*x + c*x^2)/x^5, x, 2, -(a/(4*x^4)) - b/(3*x^3) - c/(2*x^2)}
{(a + b*x + c*x^2)/x^6, x, 2, -(a/(5*x^5)) - b/(4*x^4) - c/(3*x^3)}


{x^m*(a + b*x + c*x^2)^2, x, 2, (a^2*x^(1 + m))/(1 + m) + (2*a*b*x^(2 + m))/(2 + m) + ((b^2 + 2*a*c)*x^(3 + m))/(3 + m) + (2*b*c*x^(4 + m))/(4 + m) + (c^2*x^(5 + m))/(5 + m)}

{x^4*(a + b*x + c*x^2)^2, x, 2, (a^2*x^5)/5 + (1/3)*a*b*x^6 + (1/7)*(b^2 + 2*a*c)*x^7 + (1/4)*b*c*x^8 + (c^2*x^9)/9}
{x^3*(a + b*x + c*x^2)^2, x, 2, (a^2*x^4)/4 + (2/5)*a*b*x^5 + (1/6)*(b^2 + 2*a*c)*x^6 + (2/7)*b*c*x^7 + (c^2*x^8)/8}
{x^2*(a + b*x + c*x^2)^2, x, 2, (a^2*x^3)/3 + (1/2)*a*b*x^4 + (1/5)*(b^2 + 2*a*c)*x^5 + (1/3)*b*c*x^6 + (c^2*x^7)/7}
{x^1*(a + b*x + c*x^2)^2, x, 2, (a^2*x^2)/2 + (2/3)*a*b*x^3 + (1/4)*(b^2 + 2*a*c)*x^4 + (2/5)*b*c*x^5 + (c^2*x^6)/6}
{x^0*(a + b*x + c*x^2)^2, x, 2, a^2*x + a*b*x^2 + (1/3)*(b^2 + 2*a*c)*x^3 + (1/2)*b*c*x^4 + (c^2*x^5)/5}
{(a + b*x + c*x^2)^2/x^1, x, 2, 2*a*b*x + (1/2)*(b^2 + 2*a*c)*x^2 + (2/3)*b*c*x^3 + (c^2*x^4)/4 + a^2*Log[x]}
{(a + b*x + c*x^2)^2/x^2, x, 2, -(a^2/x) + (b^2 + 2*a*c)*x + b*c*x^2 + (c^2*x^3)/3 + 2*a*b*Log[x]}
{(a + b*x + c*x^2)^2/x^3, x, 2, -(a^2/(2*x^2)) - (2*a*b)/x + 2*b*c*x + (c^2*x^2)/2 + (b^2 + 2*a*c)*Log[x]}
{(a + b*x + c*x^2)^2/x^4, x, 2, -(a^2/(3*x^3)) - (a*b)/x^2 - (b^2 + 2*a*c)/x + c^2*x + 2*b*c*Log[x]}
{(a + b*x + c*x^2)^2/x^5, x, 2, -(a^2/(4*x^4)) - (2*a*b)/(3*x^3) - (b^2 + 2*a*c)/(2*x^2) - (2*b*c)/x + c^2*Log[x]}
{(a + b*x + c*x^2)^2/x^6, x, 2, -(a^2/(5*x^5)) - (a*b)/(2*x^4) - (b^2 + 2*a*c)/(3*x^3) - (b*c)/x^2 - c^2/x}


{x^m*(a + b*x + c*x^2)^3, x, 2, (a^3*x^(1 + m))/(1 + m) + (3*a^2*b*x^(2 + m))/(2 + m) + (3*a*(b^2 + a*c)*x^(3 + m))/(3 + m) + (b*(b^2 + 6*a*c)*x^(4 + m))/(4 + m) + (3*c*(b^2 + a*c)*x^(5 + m))/(5 + m) + (3*b*c^2*x^(6 + m))/(6 + m) + (c^3*x^(7 + m))/(7 + m)}

{x^4*(a + b*x + c*x^2)^3, x, 2, (a^3*x^5)/5 + (1/2)*a^2*b*x^6 + (3/7)*a*(b^2 + a*c)*x^7 + (1/8)*b*(b^2 + 6*a*c)*x^8 + (1/3)*c*(b^2 + a*c)*x^9 + (3/10)*b*c^2*x^10 + (c^3*x^11)/11}
{x^3*(a + b*x + c*x^2)^3, x, 2, (a^3*x^4)/4 + (3/5)*a^2*b*x^5 + (1/2)*a*(b^2 + a*c)*x^6 + (1/7)*b*(b^2 + 6*a*c)*x^7 + (3/8)*c*(b^2 + a*c)*x^8 + (1/3)*b*c^2*x^9 + (c^3*x^10)/10}
{x^2*(a + b*x + c*x^2)^3, x, 2, (a^3*x^3)/3 + (3/4)*a^2*b*x^4 + (3/5)*a*(b^2 + a*c)*x^5 + (1/6)*b*(b^2 + 6*a*c)*x^6 + (3/7)*c*(b^2 + a*c)*x^7 + (3/8)*b*c^2*x^8 + (c^3*x^9)/9}
{x^1*(a + b*x + c*x^2)^3, x, 2, (a^3*x^2)/2 + a^2*b*x^3 + (3/4)*a*(b^2 + a*c)*x^4 + (1/5)*b*(b^2 + 6*a*c)*x^5 + (1/2)*c*(b^2 + a*c)*x^6 + (3/7)*b*c^2*x^7 + (c^3*x^8)/8}
{x^0*(a + b*x + c*x^2)^3, x, 2, a^3*x + (3/2)*a^2*b*x^2 + a*(b^2 + a*c)*x^3 + (1/4)*b*(b^2 + 6*a*c)*x^4 + (3/5)*c*(b^2 + a*c)*x^5 + (1/2)*b*c^2*x^6 + (c^3*x^7)/7}
{(a + b*x + c*x^2)^3/x^1, x, 2, 3*a^2*b*x + (3/2)*a*(b^2 + a*c)*x^2 + (1/3)*b*(b^2 + 6*a*c)*x^3 + (3/4)*c*(b^2 + a*c)*x^4 + (3/5)*b*c^2*x^5 + (c^3*x^6)/6 + a^3*Log[x]}
{(a + b*x + c*x^2)^3/x^2, x, 2, -(a^3/x) + 3*a*(b^2 + a*c)*x + (1/2)*b*(b^2 + 6*a*c)*x^2 + c*(b^2 + a*c)*x^3 + (3/4)*b*c^2*x^4 + (c^3*x^5)/5 + 3*a^2*b*Log[x]}
{(a + b*x + c*x^2)^3/x^3, x, 2, -(a^3/(2*x^2)) - (3*a^2*b)/x + b*(b^2 + 6*a*c)*x + (3/2)*c*(b^2 + a*c)*x^2 + b*c^2*x^3 + (c^3*x^4)/4 + 3*a*(b^2 + a*c)*Log[x]}
{(a + b*x + c*x^2)^3/x^4, x, 2, -(a^3/(3*x^3)) - (3*a^2*b)/(2*x^2) - (3*a*(b^2 + a*c))/x + 3*c*(b^2 + a*c)*x + (3/2)*b*c^2*x^2 + (c^3*x^3)/3 + b*(b^2 + 6*a*c)*Log[x]}
{(a + b*x + c*x^2)^3/x^5, x, 2, -(a^3/(4*x^4)) - (a^2*b)/x^3 - (3*a*(b^2 + a*c))/(2*x^2) - (b*(b^2 + 6*a*c))/x + 3*b*c^2*x + (c^3*x^2)/2 + 3*c*(b^2 + a*c)*Log[x]}
{(a + b*x + c*x^2)^3/x^6, x, 2, -(a^3/(5*x^5)) - (3*a^2*b)/(4*x^4) - (a*(b^2 + a*c))/x^3 - (b*(b^2 + 6*a*c))/(2*x^2) - (3*c*(b^2 + a*c))/x + c^3*x + 3*b*c^2*Log[x]}


{x^m*(3 - 4*x + x^2), x, 2, (3*x^(1 + m))/(1 + m) - (4*x^(2 + m))/(2 + m) + x^(3 + m)/(3 + m)}

{x^3*(3 - 4*x + x^2), x, 2, (3*x^4)/4 - (4*x^5)/5 + x^6/6}
{x^2*(3 - 4*x + x^2), x, 2, x^3 - x^4 + x^5/5}
{x^1*(3 - 4*x + x^2), x, 2, (3*x^2)/2 - (4*x^3)/3 + x^4/4}
{x^0*(3 - 4*x + x^2), x, 1, 3*x - 2*x^2 + x^3/3}
{(3 - 4*x + x^2)/x^1, x, 2, -4*x + x^2/2 + 3*Log[x]}
{(3 - 4*x + x^2)/x^2, x, 2, -(3/x) + x - 4*Log[x]}
{(3 - 4*x + x^2)/x^3, x, 2, -(3/(2*x^2)) + 4/x + Log[x]}
{(3 - 4*x + x^2)/x^4, x, 2, -(1/x^3) + 2/x^2 - 1/x}
{(3 - 4*x + x^2)/x^5, x, 2, -(3/(4*x^4)) + 4/(3*x^3) - 1/(2*x^2)}


{(1 + x + x^2)/x, x, 2, x + x^2/2 + Log[x]}
{(9 + 6*x + x^2)/x^2, x, 3, -9/x + x + 6*Log[x]}
{(1 + 2*x + x^2)/x^4, x, 2, -((1 + x)^3/(3*x^3))}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^5/(a + b*x + c*x^2), x, 5, -((b*(b^2 - 2*a*c)*x)/c^4) + ((b^2 - a*c)*x^2)/(2*c^3) - (b*x^3)/(3*c^2) + x^4/(4*c) + (b*(b^4 - 5*a*b^2*c + 5*a^2*c^2)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(c^5*Sqrt[b^2 - 4*a*c]) + ((b^4 - 3*a*b^2*c + a^2*c^2)*Log[a + b*x + c*x^2])/(2*c^5)}
{x^4/(a + b*x + c*x^2), x, 5, ((b^2 - a*c)*x)/c^3 - (b*x^2)/(2*c^2) + x^3/(3*c) - ((b^4 - 4*a*b^2*c + 2*a^2*c^2)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(c^4*Sqrt[b^2 - 4*a*c]) - (b*(b^2 - 2*a*c)*Log[a + b*x + c*x^2])/(2*c^4)}
{x^3/(a + b*x + c*x^2), x, 5, -((b*x)/c^2) + x^2/(2*c) + (b*(b^2 - 3*a*c)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(c^3*Sqrt[b^2 - 4*a*c]) + ((b^2 - a*c)*Log[a + b*x + c*x^2])/(2*c^3)}
{x^2/(a + b*x + c*x^2), x, 4, x/c - ((b^2 - 2*a*c)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(c^2*Sqrt[b^2 - 4*a*c]) - (b*Log[a + b*x + c*x^2])/(2*c^2)}
{x^1/(a + b*x + c*x^2), x, 3, (b*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(c*Sqrt[b^2 - 4*a*c]) + Log[a + b*x + c*x^2]/(2*c)}
{x^0/(a + b*x + c*x^2), x, 1, -((2*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/Sqrt[b^2 - 4*a*c])}
{1/(x^1*(a + b*x + c*x^2)), x, 5, (b*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(a*Sqrt[b^2 - 4*a*c]) + Log[x]/a - Log[a + b*x + c*x^2]/(2*a)}
{1/(x^2*(a + b*x + c*x^2)), x, 6, -(1/(a*x)) - ((b^2 - 2*a*c)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(a^2*Sqrt[b^2 - 4*a*c]) - (b*Log[x])/a^2 + (b*Log[a + b*x + c*x^2])/(2*a^2)}
{1/(x^3*(a + b*x + c*x^2)), x, 7, -(1/(2*a*x^2)) + b/(a^2*x) + (b*(b^2 - 3*a*c)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(a^3*Sqrt[b^2 - 4*a*c]) + ((b^2 - a*c)*Log[x])/a^3 - ((b^2 - a*c)*Log[a + b*x + c*x^2])/(2*a^3)}
{1/(x^4*(a + b*x + c*x^2)), x, 8, -(1/(3*a*x^3)) + b/(2*a^2*x^2) - (b^2 - a*c)/(a^3*x) - ((b^4 - 4*a*b^2*c + 2*a^2*c^2)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(a^4*Sqrt[b^2 - 4*a*c]) - (b*(b^2 - 2*a*c)*Log[x])/a^4 + (b*(b^2 - 2*a*c)*Log[a + b*x + c*x^2])/(2*a^4)}


{x^5/(a + b*x + c*x^2)^2, x, 6, -((b*(3*b^2 - 11*a*c)*x)/(c^3*(b^2 - 4*a*c))) + ((3*b^2 - 8*a*c)*x^2)/(2*c^2*(b^2 - 4*a*c)) - (b*x^3)/(c*(b^2 - 4*a*c)) + (x^4*(2*a + b*x))/((b^2 - 4*a*c)*(a + b*x + c*x^2)) + (b*(3*b^4 - 20*a*b^2*c + 30*a^2*c^2)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(c^4*(b^2 - 4*a*c)^(3/2)) + ((3*b^2 - 2*a*c)*Log[a + b*x + c*x^2])/(2*c^4)}
{x^4/(a + b*x + c*x^2)^2, x, 6, (2*(b^2 - 3*a*c)*x)/(c^2*(b^2 - 4*a*c)) - (b*x^2)/(c*(b^2 - 4*a*c)) + (x^3*(2*a + b*x))/((b^2 - 4*a*c)*(a + b*x + c*x^2)) - (2*(b^4 - 6*a*b^2*c + 6*a^2*c^2)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(c^3*(b^2 - 4*a*c)^(3/2)) - (b*Log[a + b*x + c*x^2])/c^3}
{x^3/(a + b*x + c*x^2)^2, x, 6, -((b*x)/(c*(b^2 - 4*a*c))) + (x^2*(2*a + b*x))/((b^2 - 4*a*c)*(a + b*x + c*x^2)) + (b*(b^2 - 6*a*c)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(c^2*(b^2 - 4*a*c)^(3/2)) + Log[a + b*x + c*x^2]/(2*c^2)}
{x^2/(a + b*x + c*x^2)^2, x, 2, (x*(2*a + b*x))/((b^2 - 4*a*c)*(a + b*x + c*x^2)) + (4*a*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(b^2 - 4*a*c)^(3/2)}
{x^1/(a + b*x + c*x^2)^2, x, 2, (2*a + b*x)/((b^2 - 4*a*c)*(a + b*x + c*x^2)) - (2*b*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(b^2 - 4*a*c)^(3/2)}
{x^0/(a + b*x + c*x^2)^2, x, 2, -((b + 2*c*x)/((b^2 - 4*a*c)*(a + b*x + c*x^2))) + (4*c*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(b^2 - 4*a*c)^(3/2)}
{1/(x^1*(a + b*x + c*x^2)^2), x, 6, (b^2 - 2*a*c + b*c*x)/(a*(b^2 - 4*a*c)*(a + b*x + c*x^2)) + (b*(b^2 - 6*a*c)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(a^2*(b^2 - 4*a*c)^(3/2)) + Log[x]/a^2 - Log[a + b*x + c*x^2]/(2*a^2)}
{1/(x^2*(a + b*x + c*x^2)^2), x, 7, -((2*(b^2 - 3*a*c))/(a^2*(b^2 - 4*a*c)*x)) + (b^2 - 2*a*c + b*c*x)/(a*(b^2 - 4*a*c)*x*(a + b*x + c*x^2)) - (2*(b^4 - 6*a*b^2*c + 6*a^2*c^2)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(a^3*(b^2 - 4*a*c)^(3/2)) - (2*b*Log[x])/a^3 + (b*Log[a + b*x + c*x^2])/a^3}
{1/(x^3*(a + b*x + c*x^2)^2), x, 8, -((3*b^2 - 8*a*c)/(2*a^2*(b^2 - 4*a*c)*x^2)) + (b*(3*b^2 - 11*a*c))/(a^3*(b^2 - 4*a*c)*x) + (b^2 - 2*a*c + b*c*x)/(a*(b^2 - 4*a*c)*x^2*(a + b*x + c*x^2)) + (b*(3*b^4 - 20*a*b^2*c + 30*a^2*c^2)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(a^4*(b^2 - 4*a*c)^(3/2)) + ((3*b^2 - 2*a*c)*Log[x])/a^4 - ((3*b^2 - 2*a*c)*Log[a + b*x + c*x^2])/(2*a^4)}


{x^7/(a + b*x + c*x^2)^3, x, 7, -((3*b*(2*b^2 - 9*a*c)*(b^2 - 3*a*c)*x)/(c^4*(b^2 - 4*a*c)^2)) + (3*(2*b^4 - 13*a*b^2*c + 16*a^2*c^2)*x^2)/(2*c^3*(b^2 - 4*a*c)^2) - (b*(2*b^2 - 11*a*c)*x^3)/(c^2*(b^2 - 4*a*c)^2) + (3*(b^2 - 8*a*c)*x^4)/(2*c*(b^2 - 4*a*c)^2) + (x^6*(2*a + b*x))/(2*(b^2 - 4*a*c)*(a + b*x + c*x^2)^2) + (3*x^5*(2*a*b - (b^2 - 8*a*c)*x))/(2*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)) + (3*b*(2*b^6 - 21*a*b^4*c + 70*a^2*b^2*c^2 - 70*a^3*c^3)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(c^5*(b^2 - 4*a*c)^(5/2)) + (3*(2*b^2 - a*c)*Log[a + b*x + c*x^2])/(2*c^5)}
{x^6/(a + b*x + c*x^2)^3, x, 7, (3*(b^4 - 7*a*b^2*c + 10*a^2*c^2)*x)/(c^3*(b^2 - 4*a*c)^2) - (3*b*(b^2 - 6*a*c)*x^2)/(2*c^2*(b^2 - 4*a*c)^2) + ((b^2 - 10*a*c)*x^3)/(c*(b^2 - 4*a*c)^2) + (x^5*(2*a + b*x))/(2*(b^2 - 4*a*c)*(a + b*x + c*x^2)^2) + (x^4*(3*a*b - (b^2 - 10*a*c)*x))/((b^2 - 4*a*c)^2*(a + b*x + c*x^2)) - (3*(b^6 - 10*a*b^4*c + 30*a^2*b^2*c^2 - 20*a^3*c^3)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(c^4*(b^2 - 4*a*c)^(5/2)) - (3*b*Log[a + b*x + c*x^2])/(2*c^4)}
{x^5/(a + b*x + c*x^2)^3, x, 7, -((b*(b^2 - 7*a*c)*x)/(c^2*(b^2 - 4*a*c)^2)) + ((b^2 - 16*a*c)*x^2)/(2*c*(b^2 - 4*a*c)^2) + (x^4*(2*a + b*x))/(2*(b^2 - 4*a*c)*(a + b*x + c*x^2)^2) + (x^3*(6*a*b - (b^2 - 16*a*c)*x))/(2*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)) + (b*(b^4 - 10*a*b^2*c + 30*a^2*c^2)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(c^3*(b^2 - 4*a*c)^(5/2)) + Log[a + b*x + c*x^2]/(2*c^3)}
{x^4/(a + b*x + c*x^2)^3, x, 3, (x^3*(2*a + b*x))/(2*(b^2 - 4*a*c)*(a + b*x + c*x^2)^2) - (3*a*x*(2*a + b*x))/((b^2 - 4*a*c)^2*(a + b*x + c*x^2)) - (12*a^2*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(b^2 - 4*a*c)^(5/2)}
{x^3/(a + b*x + c*x^2)^3, x, 3, -((x^3*(b + 2*c*x))/(2*(b^2 - 4*a*c)*(a + b*x + c*x^2)^2)) + (3*b*x*(2*a + b*x))/(2*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)) + (6*a*b*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(b^2 - 4*a*c)^(5/2)}
{x^2/(a + b*x + c*x^2)^3, x, 3, (x^3*(b^2 - 2*a*c + b*c*x))/(2*a*(b^2 - 4*a*c)*(a + b*x + c*x^2)^2) - ((b^2 + 2*a*c)*x*(2*a + b*x))/(2*a*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)) - (2*(b^2 + 2*a*c)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(b^2 - 4*a*c)^(5/2)}
{x^1/(a + b*x + c*x^2)^3, x, 3, (2*a + b*x)/(2*(b^2 - 4*a*c)*(a + b*x + c*x^2)^2) - (3*b*(b + 2*c*x))/(2*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)) + (6*b*c*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(b^2 - 4*a*c)^(5/2)}
{x^0/(a + b*x + c*x^2)^3, x, 3, -((b + 2*c*x)/(2*(b^2 - 4*a*c)*(a + b*x + c*x^2)^2)) + (3*c*(b + 2*c*x))/((b^2 - 4*a*c)^2*(a + b*x + c*x^2)) - (12*c^2*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(b^2 - 4*a*c)^(5/2)}
{1/(x^1*(a + b*x + c*x^2)^3), x, 7, (b^2 - 2*a*c + b*c*x)/(2*a*(b^2 - 4*a*c)*(a + b*x + c*x^2)^2) + (2*b^4 - 15*a*b^2*c + 16*a^2*c^2 + 2*b*c*(b^2 - 7*a*c)*x)/(2*a^2*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)) + (b*(b^4 - 10*a*b^2*c + 30*a^2*c^2)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(a^3*(b^2 - 4*a*c)^(5/2)) + Log[x]/a^3 - Log[a + b*x + c*x^2]/(2*a^3)}
{1/(x^2*(a + b*x + c*x^2)^3), x, 8, -((3*(b^2 - 5*a*c)*(b^2 - 2*a*c))/(a^3*(b^2 - 4*a*c)^2*x)) + (b^2 - 2*a*c + b*c*x)/(2*a*(b^2 - 4*a*c)*x*(a + b*x + c*x^2)^2) + (3*b^4 - 20*a*b^2*c + 20*a^2*c^2 + 3*b*c*(b^2 - 6*a*c)*x)/(2*a^2*(b^2 - 4*a*c)^2*x*(a + b*x + c*x^2)) - (3*(b^6 - 10*a*b^4*c + 30*a^2*b^2*c^2 - 20*a^3*c^3)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(a^4*(b^2 - 4*a*c)^(5/2)) - (3*b*Log[x])/a^4 + (3*b*Log[a + b*x + c*x^2])/(2*a^4)}
{1/(x^3*(a + b*x + c*x^2)^3), x, 9, -((3*(2*b^4 - 13*a*b^2*c + 16*a^2*c^2))/(2*a^3*(b^2 - 4*a*c)^2*x^2)) + (3*b*(2*b^2 - 9*a*c)*(b^2 - 3*a*c))/(a^4*(b^2 - 4*a*c)^2*x) + (b^2 - 2*a*c + b*c*x)/(2*a*(b^2 - 4*a*c)*x^2*(a + b*x + c*x^2)^2) + (4*b^4 - 25*a*b^2*c + 24*a^2*c^2 + 2*b*c*(2*b^2 - 11*a*c)*x)/(2*a^2*(b^2 - 4*a*c)^2*x^2*(a + b*x + c*x^2)) + (3*b*(2*b^6 - 21*a*b^4*c + 70*a^2*b^2*c^2 - 70*a^3*c^3)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(a^5*(b^2 - 4*a*c)^(5/2)) + (3*(2*b^2 - a*c)*Log[x])/a^5 - (3*(2*b^2 - a*c)*Log[a + b*x + c*x^2])/(2*a^5)}


{x^8/(a + b*x + c*x^2)^4, x, 8, (4*(b^6 - 11*a*b^4*c + 38*a^2*b^2*c^2 - 35*a^3*c^3)*x)/(c^4*(b^2 - 4*a*c)^3) - (2*b*(b^4 - 10*a*b^2*c + 29*a^2*c^2)*x^2)/(c^3*(b^2 - 4*a*c)^3) + (4*(b^4 - 9*a*b^2*c + 35*a^2*c^2)*x^3)/(3*c^2*(b^2 - 4*a*c)^3) - (b*(b^2 + 6*a*c)*x^4)/(c*(b^2 - 4*a*c)^3) + (x^7*(2*a + b*x))/(3*(b^2 - 4*a*c)*(a + b*x + c*x^2)^3) + (x^6*(5*a*b - (b^2 - 14*a*c)*x))/(3*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)^2) + (x^5*(4*a*(3*b^2 - 7*a*c) + b*(b^2 + 6*a*c)*x))/((b^2 - 4*a*c)^3*(a + b*x + c*x^2)) - (4*(b^8 - 14*a*b^6*c + 70*a^2*b^4*c^2 - 140*a^3*b^2*c^3 + 70*a^4*c^4)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(c^5*(b^2 - 4*a*c)^(7/2)) - (2*b*Log[a + b*x + c*x^2])/c^5}
{x^7/(a + b*x + c*x^2)^4, x, 8, -((b*(b^4 - 11*a*b^2*c + 38*a^2*c^2)*x)/(c^3*(b^2 - 4*a*c)^3)) + ((b^4 - 10*a*b^2*c + 64*a^2*c^2)*x^2)/(2*c^2*(b^2 - 4*a*c)^3) - (b*(b^2 + 26*a*c)*x^3)/(3*c*(b^2 - 4*a*c)^3) + (x^6*(2*a + b*x))/(3*(b^2 - 4*a*c)*(a + b*x + c*x^2)^3) + (x^5*(10*a*b - (b^2 - 24*a*c)*x))/(6*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)^2) + (x^4*(3*a*(9*b^2 - 16*a*c) + b*(b^2 + 26*a*c)*x))/(3*(b^2 - 4*a*c)^3*(a + b*x + c*x^2)) + (b*(b^6 - 14*a*b^4*c + 70*a^2*b^2*c^2 - 140*a^3*c^3)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(c^4*(b^2 - 4*a*c)^(7/2)) + Log[a + b*x + c*x^2]/(2*c^4)}
{x^6/(a + b*x + c*x^2)^4, x, 4, (x^5*(2*a + b*x))/(3*(b^2 - 4*a*c)*(a + b*x + c*x^2)^3) - (5*a*x^3*(2*a + b*x))/(3*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)^2) + (10*a^2*x*(2*a + b*x))/((b^2 - 4*a*c)^3*(a + b*x + c*x^2)) + (40*a^3*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(b^2 - 4*a*c)^(7/2)}
{x^5/(a + b*x + c*x^2)^4, x, 4, -((x^5*(b + 2*c*x))/(3*(b^2 - 4*a*c)*(a + b*x + c*x^2)^3)) + (5*b*x^3*(2*a + b*x))/(6*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)^2) - (5*a*b*x*(2*a + b*x))/((b^2 - 4*a*c)^3*(a + b*x + c*x^2)) - (20*a^2*b*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(b^2 - 4*a*c)^(7/2)}
{x^4/(a + b*x + c*x^2)^4, x, 4, (x^5*(b^2 - 2*a*c + b*c*x))/(3*a*(b^2 - 4*a*c)*(a + b*x + c*x^2)^3) - ((b^2 + a*c)*x^3*(2*a + b*x))/(3*a*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)^2) + (2*(b^2 + a*c)*x*(2*a + b*x))/((b^2 - 4*a*c)^3*(a + b*x + c*x^2)) + (8*a*(b^2 + a*c)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(b^2 - 4*a*c)^(7/2)}
{x^3/(a + b*x + c*x^2)^4, x, 4, (x^2*(2*a + b*x))/(3*(b^2 - 4*a*c)*(a + b*x + c*x^2)^3) - ((4*a - 3*b*x)*(2*a + b*x))/(6*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)^2) + (b*(5*a*b + (b^2 + 6*a*c)*x))/((b^2 - 4*a*c)^3*(a + b*x + c*x^2)) - (2*b*(b^2 + 6*a*c)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(b^2 - 4*a*c)^(7/2)}
{x^2/(a + b*x + c*x^2)^4, x, 4, (x*(2*a + b*x))/(3*(b^2 - 4*a*c)*(a + b*x + c*x^2)^3) + (5*a*b + 2*(b^2 + a*c)*x)/(3*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)^2) - (2*(b^2 + a*c)*(b + 2*c*x))/((b^2 - 4*a*c)^3*(a + b*x + c*x^2)) + (8*c*(b^2 + a*c)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(b^2 - 4*a*c)^(7/2)}
{x^1/(a + b*x + c*x^2)^4, x, 4, (2*a + b*x)/(3*(b^2 - 4*a*c)*(a + b*x + c*x^2)^3) - (5*b*(b + 2*c*x))/(6*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)^2) + (5*b*c*(b + 2*c*x))/((b^2 - 4*a*c)^3*(a + b*x + c*x^2)) - (20*b*c^2*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(b^2 - 4*a*c)^(7/2)}
{x^0/(a + b*x + c*x^2)^4, x, 4, -((b + 2*c*x)/(3*(b^2 - 4*a*c)*(a + b*x + c*x^2)^3)) + (5*c*(b + 2*c*x))/(3*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)^2) - (10*c^2*(b + 2*c*x))/((b^2 - 4*a*c)^3*(a + b*x + c*x^2)) + (40*c^3*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(b^2 - 4*a*c)^(7/2)}
{1/(x^1*(a + b*x + c*x^2)^4), x, 8, (b^2 - 2*a*c + b*c*x)/(3*a*(b^2 - 4*a*c)*(a + b*x + c*x^2)^3) + (3*b^4 - 23*a*b^2*c + 24*a^2*c^2 + b*c*(3*b^2 - 22*a*c)*x)/(6*a^2*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)^2) + (2*b^6 - 23*a*b^4*c + 86*a^2*b^2*c^2 - 64*a^3*c^3 + 2*b*c*(b^4 - 11*a*b^2*c + 38*a^2*c^2)*x)/(2*a^3*(b^2 - 4*a*c)^3*(a + b*x + c*x^2)) + (b*(b^6 - 14*a*b^4*c + 70*a^2*b^2*c^2 - 140*a^3*c^3)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(a^4*(b^2 - 4*a*c)^(7/2)) + Log[x]/a^4 - Log[a + b*x + c*x^2]/(2*a^4)}
{1/(x^2*(a + b*x + c*x^2)^4), x, 9, -((4*(b^6 - 11*a*b^4*c + 38*a^2*b^2*c^2 - 35*a^3*c^3))/(a^4*(b^2 - 4*a*c)^3*x)) + (b^2 - 2*a*c + b*c*x)/(3*a*(b^2 - 4*a*c)*x*(a + b*x + c*x^2)^3) + (2*(b^4 - 7*a*b^2*c + 7*a^2*c^2) + b*c*(2*b^2 - 13*a*c)*x)/(3*a^2*(b^2 - 4*a*c)^2*x*(a + b*x + c*x^2)^2) + (2*(3*b^6 - 32*a*b^4*c + 105*a^2*b^2*c^2 - 70*a^3*c^3 + 3*b*c*(b^4 - 10*a*b^2*c + 29*a^2*c^2)*x))/(3*a^3*(b^2 - 4*a*c)^3*x*(a + b*x + c*x^2)) - (4*(b^8 - 14*a*b^6*c + 70*a^2*b^4*c^2 - 140*a^3*b^2*c^3 + 70*a^4*c^4)*ArcTanh[(b + 2*c*x)/Sqrt[b^2 - 4*a*c]])/(a^5*(b^2 - 4*a*c)^(7/2)) - (4*b*Log[x])/a^5 + (2*b*Log[a + b*x + c*x^2])/a^5}


{x^4/(2 + 13*x + 15*x^2), x, 5, (139*x)/3375 - (13*x^2)/450 + x^3/45 - (16/567)*Log[2 + 3*x] + Log[1 + 5*x]/4375}
{x^3/(2 + 13*x + 15*x^2), x, 5, -((13*x)/225) + x^2/30 + (8/189)*Log[2 + 3*x] - (1/875)*Log[1 + 5*x]}
{x^2/(2 + 13*x + 15*x^2), x, 4, x/15 - (4/63)*Log[2 + 3*x] + (1/175)*Log[1 + 5*x]}
{x^1/(2 + 13*x + 15*x^2), x, 3, (2/21)*Log[2 + 3*x] - (1/35)*Log[1 + 5*x]}
{x^0/(2 + 13*x + 15*x^2), x, 3, (-(1/7))*Log[2 + 3*x] + (1/7)*Log[1 + 5*x]}
{1/(x^1*(2 + 13*x + 15*x^2)), x, 5, Log[x]/2 + (3/14)*Log[2 + 3*x] - (5/7)*Log[1 + 5*x]}
{1/(x^2*(2 + 13*x + 15*x^2)), x, 6, -(1/(2*x)) - (13*Log[x])/4 - (9/28)*Log[2 + 3*x] + (25/7)*Log[1 + 5*x]}
{1/(x^3*(2 + 13*x + 15*x^2)), x, 7, -(1/(4*x^2)) + 13/(4*x) + (139*Log[x])/8 + (27/56)*Log[2 + 3*x] - (125/7)*Log[1 + 5*x]}
{1/(x^4*(2 + 13*x + 15*x^2)), x, 8, -(1/(6*x^3)) + 13/(8*x^2) - 139/(8*x) - (1417*Log[x])/16 - (81/112)*Log[2 + 3*x] + (625/7)*Log[1 + 5*x]}


{1/(2 + 4*x + 3*x^2), x, 1, ArcTan[(2 + 3*x)/Sqrt[2]]/Sqrt[2]}
{1/(4 - 2*Sqrt[3]*x + x^2), x, 1, -ArcTan[Sqrt[3] - x]}
{1/(2 + 4*x - 3*x^2), x, 1, -(ArcTanh[(2 - 3*x)/Sqrt[10]]/Sqrt[10])}
{1/(2 + 5*x + 3*x^2), x, 1, -2*ArcTanh[5 + 6*x]}
{1/(2 + 5*x - 3*x^2), x, 3, (-(1/7))*Log[2 - x] + (1/7)*Log[1 + 3*x]}
{1/(3 + 4*x + x^2), x, 3, -ArcTanh[2 + x], (1/2)*Log[1 + x] - (1/2)*Log[3 + x]}
{1/(1 + Pi*x + 2*x^2), x, 1, (-2*ArcTanh[(Pi + 4*x)/Sqrt[-8 + Pi^2]])/Sqrt[-8 + Pi^2]}
{1/(1 + Pi*x - 2*x^2), x, 1, (-2*ArcTanh[(Pi - 4*x)/Sqrt[8 + Pi^2]])/Sqrt[8 + Pi^2]}
{1/(1 + Pi*x + 3*x^2), x, 1, (2*ArcTan[(Pi + 6*x)/Sqrt[12 - Pi^2]])/Sqrt[12 - Pi^2]}
{1/(1 + Pi*x - 3*x^2), x, 1, (-2*ArcTanh[(Pi - 6*x)/Sqrt[12 + Pi^2]])/Sqrt[12 + Pi^2]}
{1/(a + c*x + b*x^2), x, 1, (2*ArcTan[(c + 2*b*x)/Sqrt[4*a*b - c^2]])/Sqrt[4*a*b - c^2]}
{1/(b + 2*a*x + b*x^2), x, 1, -(ArcTanh[(a + b*x)/Sqrt[a^2 - b^2]]/Sqrt[a^2 - b^2])}
{1/(b + 2*a*x - b*x^2), x, 1, -(ArcTanh[(a - b*x)/Sqrt[a^2 + b^2]]/Sqrt[a^2 + b^2])}


{1/(2 + 4*x + 3*x^2)^2, x, 2, (2 + 3*x)/(4*(2 + 4*x + 3*x^2)) + (3*ArcTan[(2 + 3*x)/Sqrt[2]])/(4*Sqrt[2])}
{1/(2 + 4*x - 3*x^2)^2, x, 2, -((2 - 3*x)/(20*(2 + 4*x - 3*x^2))) - (3*ArcTanh[(2 - 3*x)/Sqrt[10]])/(20*Sqrt[10])}
{1/(2 + 5*x + 3*x^2)^2, x, 2, -((5 + 6*x)/(2 + 5*x + 3*x^2)) + 12*ArcTanh[5 + 6*x]}
{1/(2 + 5*x - 3*x^2)^2, x, 4, -((5 - 6*x)/(49*(2 + 5*x - 3*x^2))) - (6/343)*Log[2 - x] + (6/343)*Log[1 + 3*x]}
{1/(a + c*x + b*x^2)^2, x, 2, (c + 2*b*x)/((4*a*b - c^2)*(a + c*x + b*x^2)) + (4*b*ArcTan[(c + 2*b*x)/Sqrt[4*a*b - c^2]])/(4*a*b - c^2)^(3/2)}
{1/(b + 2*a*x + b*x^2)^2, x, 2, -((a + b*x)/(2*(a^2 - b^2)*(b + 2*a*x + b*x^2))) + (b*ArcTanh[(a + b*x)/Sqrt[a^2 - b^2]])/(2*(a^2 - b^2)^(3/2))}
{1/(b + 2*a*x - b*x^2)^2, x, 2, -((a - b*x)/(2*(a^2 + b^2)*(b + 2*a*x - b*x^2))) - (b*ArcTanh[(a - b*x)/Sqrt[a^2 + b^2]])/(2*(a^2 + b^2)^(3/2))}


{x/(4 + 4*x + x^2), x, 3, 2/(2 + x) + Log[2 + x]}
{x/(5 + 2*x + x^2), x, 3, (-(1/2))*ArcTan[1/2 + x/2] + (1/2)*Log[5 + 2*x + x^2]}
{x/(6 - 5*x + x^2), x, 3, -2*Log[2 - x] + 3*Log[3 - x]}
{x/(2 + 2*x + x^2)^2, x, 2, -((2 + x)/(2*(2 + 2*x + x^2))) - (1/2)*ArcTan[1 + x]}
{x/(1 + x + x^2)^3, x, 3, -((2 + x)/(6*(1 + x + x^2)^2)) - (1 + 2*x)/(6*(1 + x + x^2)) - (2*ArcTan[(1 + 2*x)/Sqrt[3]])/(3*Sqrt[3])}

{x^2/(1 + x + x^2), x, 4, x - ArcTan[(1 + 2*x)/Sqrt[3]]/Sqrt[3] - Log[1 + x + x^2]/2}
{x^2/(2 - 3*x + x^2), x, 4, x - Log[1 - x] + 4*Log[2 - x]}
{x^2/(-6 + x + x^2), x, 4, x + (4/5)*Log[2 - x] - (9/5)*Log[3 + x]}
{x^2/(2 + 2*x + x^2)^2, x, 2, (2 + 2*x + x^2)^(-1) + ArcTan[1 + x], -((x*(2 + x))/(2*(2 + 2*x + x^2))) + ArcTan[1 + x]}

{x^3/(2 - 3*x + x^2), x, 5, 3*x + x^2/2 - Log[1 - x] + 8*Log[2 - x]}
{x^3/(1 + 2*x + x^2), x, 3, -2*x + x^2/2 + 1/(1 + x) + 3*Log[1 + x]}
{x^3/(1 - 2*x + x^2), x, 3, 1/(1 - x) + 2*x + x^2/2 + 3*Log[1 - x]}

{x^4/(4 + 4*x + x^2), x, 3, 12*x - 2*x^2 + x^3/3 - 16/(2 + x) - 32*Log[2 + x]}

{1/(x*(1 + x + x^2)), x, 5, -(ArcTan[(1 + 2*x)/Sqrt[3]]/Sqrt[3]) + Log[x] - Log[1 + x + x^2]/2}


{1/((a/b)^(2/n) + x^2 - 2*(a/b)^(1/n)*x*Cos[(Pi - 2*k*Pi)/n]), x, 1, (ArcTan[((x - (a/b)^(1/n)*Cos[(Pi - 2*k*Pi)/n])*Csc[(Pi - 2*k*Pi)/n])/(a/b)^n^(-1)]*Csc[(Pi - 2*k*Pi)/n])/(a/b)^n^(-1)}


{1/(a*b + Sqrt[b^2 - 4*a*b^3]*x - b^2*x^2), x, 3, 2*(ArcTanh[(-Sqrt[b^2 - 4*a*b^3] + 2*b^2*x)/b]/b), -(Log[b + Sqrt[b^2 - 4*a*b^3] - 2*b^2*x]/b) + Log[b - Sqrt[b^2 - 4*a*b^3] + 2*b^2*x]/b}
{1/(a*b - Sqrt[b^2 - 4*a*b^3]*x - b^2*x^2), x, 3, 2*(ArcTanh[(Sqrt[b^2 - 4*a*b^3] + 2*b^2*x)/b]/b), -(Log[b - Sqrt[b^2 - 4*a*b^3] - 2*b^2*x]/b) + Log[b + Sqrt[b^2 - 4*a*b^3] + 2*b^2*x]/b}


{x^5/(2*x + 13*x^2 + 15*x^3), x, 6, (139*x)/3375 - (13*x^2)/450 + x^3/45 - (16/567)*Log[2 + 3*x] + Log[1 + 5*x]/4375}
{x^4/(2*x + 13*x^2 + 15*x^3), x, 6, -((13*x)/225) + x^2/30 + (8/189)*Log[2 + 3*x] - (1/875)*Log[1 + 5*x]}
{x^3/(2*x + 13*x^2 + 15*x^3), x, 5, x/15 - (4/63)*Log[2 + 3*x] + (1/175)*Log[1 + 5*x]}
{x^2/(2*x + 13*x^2 + 15*x^3), x, 4, (2/21)*Log[2 + 3*x] - (1/35)*Log[1 + 5*x]}
{x/(2*x + 13*x^2 + 15*x^3), x, 4, (-(1/7))*Log[2 + 3*x] + (1/7)*Log[1 + 5*x]}
{1/(2*x + 13*x^2 + 15*x^3), x, 6, Log[x]/2 + (3/14)*Log[2 + 3*x] - (5/7)*Log[1 + 5*x]}
{1/(x*(2*x + 13*x^2 + 15*x^3)), x, 7, -(1/(2*x)) - (13*Log[x])/4 - (9/28)*Log[2 + 3*x] + (25/7)*Log[1 + 5*x]}
{1/(x^2*(2*x + 13*x^2 + 15*x^3)), x, 8, -(1/(4*x^2)) + 13/(4*x) + (139*Log[x])/8 + (27/56)*Log[2 + 3*x] - (125/7)*Log[1 + 5*x]}
{1/(x^3*(2*x + 13*x^2 + 15*x^3)), x, 9, -(1/(6*x^3)) + 13/(8*x^2) - 139/(8*x) - (1417*Log[x])/16 - (81/112)*Log[2 + 3*x] + (625/7)*Log[1 + 5*x]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x+c x^2)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^3*(a + b*x + c*x^2)^(1/2), x, 5, -((b*(7*b^2 - 12*a*c)*(b + 2*c*x)*Sqrt[a + b*x + c*x^2])/(128*c^4)) + ((35*b^2 - 8*a*c)*(a + b*x + c*x^2)^(3/2))/(240*c^3) + (x^2*(a + b*x + c*x^2)^(3/2))/(5*c) - ((4*a + 7*b*x)*(a + b*x + c*x^2)^(3/2))/(40*c^2) + (b*(7*b^2 - 12*a*c)*(b^2 - 4*a*c)*ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])])/(256*c^(9/2))}
{x^2*(a + b*x + c*x^2)^(1/2), x, 4, ((5*b^2 - 4*a*c)*(b + 2*c*x)*Sqrt[a + b*x + c*x^2])/(64*c^3) - (5*b*(a + b*x + c*x^2)^(3/2))/(24*c^2) + (x*(a + b*x + c*x^2)^(3/2))/(4*c) - ((b^2 - 4*a*c)*(5*b^2 - 4*a*c)*ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])])/(128*c^(7/2))}
{x^1*(a + b*x + c*x^2)^(1/2), x, 3, -((b*(b + 2*c*x)*Sqrt[a + b*x + c*x^2])/(8*c^2)) + (a + b*x + c*x^2)^(3/2)/(3*c) + (b*(b^2 - 4*a*c)*ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])])/(16*c^(5/2))}
{x^0*(a + b*x + c*x^2)^(1/2), x, 2, ((b + 2*c*x)*Sqrt[a + b*x + c*x^2])/(4*c) - ((b^2 - 4*a*c)*ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])])/(8*c^(3/2))}
{(a + b*x + c*x^2)^(1/2)/x^1, x, 4, Sqrt[a + b*x + c*x^2] - Sqrt[a]*ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])] + (b*ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])])/(2*Sqrt[c])}
{(a + b*x + c*x^2)^(1/2)/x^2, x, 4, -(Sqrt[a + b*x + c*x^2]/x) - (b*ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])])/(2*Sqrt[a]) + Sqrt[c]*ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])]}
{(a + b*x + c*x^2)^(1/2)/x^3, x, 2, -(((2*a + b*x)*Sqrt[a + b*x + c*x^2])/(4*a*x^2)) + ((b^2 - 4*a*c)*ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])])/(8*a^(3/2))}
{(a + b*x + c*x^2)^(1/2)/x^4, x, 3, (b*(2*a + b*x)*Sqrt[a + b*x + c*x^2])/(8*a^2*x^2) - (a + b*x + c*x^2)^(3/2)/(3*a*x^3) - (b*(b^2 - 4*a*c)*ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])])/(16*a^(5/2))}
{(a + b*x + c*x^2)^(1/2)/x^5, x, 6, -(Sqrt[a + b*x + c*x^2]/(4*x^4)) - (b*Sqrt[a + b*x + c*x^2])/(24*a*x^3) + ((5*b^2 - 12*a*c)*Sqrt[a + b*x + c*x^2])/(96*a^2*x^2) - (b*(15*b^2 - 52*a*c)*Sqrt[a + b*x + c*x^2])/(192*a^3*x) + ((b^2 - 4*a*c)*(5*b^2 - 4*a*c)*ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])])/(128*a^(7/2))}


{x^3*(a + b*x + c*x^2)^(3/2), x, 6, (3*b*(b^2 - 4*a*c)*(3*b^2 - 4*a*c)*(b + 2*c*x)*Sqrt[a + b*x + c*x^2])/(1024*c^5) - (b*(3*b^2 - 4*a*c)*(b + 2*c*x)*(a + b*x + c*x^2)^(3/2))/(128*c^4) + ((63*b^2 - 8*a*c)*(a + b*x + c*x^2)^(5/2))/(840*c^3) + (x^2*(a + b*x + c*x^2)^(5/2))/(7*c) - ((4*a + 9*b*x)*(a + b*x + c*x^2)^(5/2))/(84*c^2) - (3*b*(b^2 - 4*a*c)^2*(3*b^2 - 4*a*c)*ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])])/(2048*c^(11/2))}
{x^2*(a + b*x + c*x^2)^(3/2), x, 5, -(((b^2 - 4*a*c)*(7*b^2 - 4*a*c)*(b + 2*c*x)*Sqrt[a + b*x + c*x^2])/(512*c^4)) + ((7*b^2 - 4*a*c)*(b + 2*c*x)*(a + b*x + c*x^2)^(3/2))/(192*c^3) - (7*b*(a + b*x + c*x^2)^(5/2))/(60*c^2) + (x*(a + b*x + c*x^2)^(5/2))/(6*c) + ((b^2 - 4*a*c)^2*(7*b^2 - 4*a*c)*ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])])/(1024*c^(9/2))}
{x^1*(a + b*x + c*x^2)^(3/2), x, 4, (3*b*(b^2 - 4*a*c)*(b + 2*c*x)*Sqrt[a + b*x + c*x^2])/(128*c^3) - (b*(b + 2*c*x)*(a + b*x + c*x^2)^(3/2))/(16*c^2) + (a + b*x + c*x^2)^(5/2)/(5*c) - (3*b*(b^2 - 4*a*c)^2*ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])])/(256*c^(7/2))}
{x^0*(a + b*x + c*x^2)^(3/2), x, 3, -((3*(b^2 - 4*a*c)*(b + 2*c*x)*Sqrt[a + b*x + c*x^2])/(64*c^2)) + ((b + 2*c*x)*(a + b*x + c*x^2)^(3/2))/(8*c) + (3*(b^2 - 4*a*c)^2*ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])])/(128*c^(5/2))}
{(a + b*x + c*x^2)^(3/2)/x^1, x, 5, ((b^2 + 8*a*c + 2*b*c*x)*Sqrt[a + b*x + c*x^2])/(8*c) + (1/3)*(a + b*x + c*x^2)^(3/2) - a^(3/2)*ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])] - (b*(b^2 - 12*a*c)*ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])])/(16*c^(3/2))}
{(a + b*x + c*x^2)^(3/2)/x^2, x, 5, (3/4)*(3*b + 2*c*x)*Sqrt[a + b*x + c*x^2] - (a + b*x + c*x^2)^(3/2)/x - (3/2)*Sqrt[a]*b*ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])] + (3*(b^2 + 4*a*c)*ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])])/(8*Sqrt[c])}
{(a + b*x + c*x^2)^(3/2)/x^3, x, 5, -((3*(b - 2*c*x)*Sqrt[a + b*x + c*x^2])/(4*x)) - (a + b*x + c*x^2)^(3/2)/(2*x^2) - (3*(b^2 + 4*a*c)*ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])])/(8*Sqrt[a]) + (3/2)*b*Sqrt[c]*ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])]}
{(a + b*x + c*x^2)^(3/2)/x^4, x, 6, ((b^2 - 8*a*c + 2*b*c*x)*Sqrt[a + b*x + c*x^2])/(8*a*x) - (a + b*x + c*x^2)^(3/2)/(3*x^3) - (b*(a + b*x + c*x^2)^(3/2))/(4*a*x^2) + (b*(b^2 - 12*a*c)*ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])])/(16*a^(3/2)) + c^(3/2)*ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])]}
{(a + b*x + c*x^2)^(3/2)/x^5, x, 3, (3*(b^2 - 4*a*c)*(2*a + b*x)*Sqrt[a + b*x + c*x^2])/(64*a^2*x^2) - ((2*a + b*x)*(a + b*x + c*x^2)^(3/2))/(8*a*x^4) - (3*(b^2 - 4*a*c)^2*ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])])/(128*a^(5/2))}
{(a + b*x + c*x^2)^(3/2)/x^6, x, 4, -((3*b*(b^2 - 4*a*c)*(2*a + b*x)*Sqrt[a + b*x + c*x^2])/(128*a^3*x^2)) + (b*(2*a + b*x)*(a + b*x + c*x^2)^(3/2))/(16*a^2*x^4) - (a + b*x + c*x^2)^(5/2)/(5*a*x^5) + (3*b*(b^2 - 4*a*c)^2*ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])])/(256*a^(7/2))}
{(a + b*x + c*x^2)^(3/2)/x^7, x, 8, -(((3*b^2 - 20*a*c)*Sqrt[a + b*x + c*x^2])/(480*a*x^4)) + (b*(7*b^2 - 36*a*c)*Sqrt[a + b*x + c*x^2])/(960*a^2*x^3) - ((35*b^4 - 216*a*b^2*c + 240*a^2*c^2)*Sqrt[a + b*x + c*x^2])/(3840*a^3*x^2) + (b*(105*b^4 - 760*a*b^2*c + 1296*a^2*c^2)*Sqrt[a + b*x + c*x^2])/(7680*a^4*x) - ((3*b + 10*c*x)*Sqrt[a + b*x + c*x^2])/(60*x^5) - (a + b*x + c*x^2)^(3/2)/(6*x^6) - ((b^2 - 4*a*c)^2*(7*b^2 - 4*a*c)*ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])])/(1024*a^(9/2))}
{(a + b*x + c*x^2)^(3/2)/x^8, x, 9, -(((b^2 - 6*a*c)*Sqrt[a + b*x + c*x^2])/(280*a*x^5)) + (b*(9*b^2 - 44*a*c)*Sqrt[a + b*x + c*x^2])/(2240*a^2*x^4) - ((7*b^2 - 32*a*c)*(3*b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2])/(4480*a^3*x^3) + (b*(105*b^4 - 728*a*b^2*c + 1168*a^2*c^2)*Sqrt[a + b*x + c*x^2])/(17920*a^4*x^2) - ((315*b^6 - 2520*a*b^4*c + 5488*a^2*b^2*c^2 - 2048*a^3*c^3)*Sqrt[a + b*x + c*x^2])/(35840*a^5*x) - ((b + 3*c*x)*Sqrt[a + b*x + c*x^2])/(28*x^6) - (a + b*x + c*x^2)^(3/2)/(7*x^7) + (3*b*(b^2 - 4*a*c)^2*(3*b^2 - 4*a*c)*ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])])/(2048*a^(11/2))}


{Sqrt[5 - 6*x + 9*x^2], x, 2, (-(1/6))*(1 - 3*x)*Sqrt[5 - 6*x + 9*x^2] + (2/3)*ArcSinh[(1/2)*(-1 + 3*x)]}
{Sqrt[3 - 4*x - 4*x^2], x, 2, (1/4)*(1 + 2*x)*Sqrt[3 - 4*x - 4*x^2] - ArcSin[(1/2)*(-1 - 2*x)]}
{Sqrt[-8 + 6*x + 9*x^2], x, 2, (1/6)*(1 + 3*x)*Sqrt[-8 + 6*x + 9*x^2] - (3/2)*ArcTanh[(1 + 3*x)/Sqrt[-8 + 6*x + 9*x^2]]}
{Sqrt[2 + 4*x + 3*x^2], x, 2, (1/6)*(2 + 3*x)*Sqrt[2 + 4*x + 3*x^2] + ArcSinh[(2 + 3*x)/Sqrt[2]]/(3*Sqrt[3])}
{Sqrt[2 + 4*x - 3*x^2], x, 2, (-(1/6))*(2 - 3*x)*Sqrt[2 + 4*x - 3*x^2] - (5*ArcSin[(2 - 3*x)/Sqrt[10]])/(3*Sqrt[3])}
{Sqrt[2 + 5*x + 3*x^2], x, 2, (1/12)*(5 + 6*x)*Sqrt[2 + 5*x + 3*x^2] - ArcTanh[(5 + 6*x)/(2*Sqrt[3]*Sqrt[2 + 5*x + 3*x^2])]/(24*Sqrt[3])}
{Sqrt[2 + 5*x - 3*x^2], x, 2, (-(1/12))*(5 - 6*x)*Sqrt[2 + 5*x - 3*x^2] - (49*ArcSin[(1/7)*(5 - 6*x)])/(24*Sqrt[3])}
{Sqrt[-2 + 4*x + 3*x^2], x, 2, (1/6)*(2 + 3*x)*Sqrt[-2 + 4*x + 3*x^2] - (5*ArcTanh[(2 + 3*x)/(Sqrt[3]*Sqrt[-2 + 4*x + 3*x^2])])/(3*Sqrt[3])}
{Sqrt[-2 + 4*x - 3*x^2], x, 2, (-(1/6))*(2 - 3*x)*Sqrt[-2 + 4*x - 3*x^2] + ArcTan[(2 - 3*x)/(Sqrt[3]*Sqrt[-2 + 4*x - 3*x^2])]/(3*Sqrt[3])}
{Sqrt[-2 + 5*x + 3*x^2], x, 2, (1/12)*(5 + 6*x)*Sqrt[-2 + 5*x + 3*x^2] - (49*ArcTanh[(5 + 6*x)/(2*Sqrt[3]*Sqrt[-2 + 5*x + 3*x^2])])/(24*Sqrt[3])}
{Sqrt[-2 + 5*x - 3*x^2], x, 2, (-(1/12))*(5 - 6*x)*Sqrt[-2 + 5*x - 3*x^2] - ArcSin[5 - 6*x]/(24*Sqrt[3])}


{Sqrt[-2 - 3*x + 5*x^2]/x, x, 4, Sqrt[-2 - 3*x + 5*x^2] + Sqrt[2]*ArcTan[(4 + 3*x)/(2*Sqrt[2]*Sqrt[-2 - 3*x + 5*x^2])] + (3*ArcTanh[(3 - 10*x)/(2*Sqrt[5]*Sqrt[-2 - 3*x + 5*x^2])])/(2*Sqrt[5])}
{Sqrt[2 - x - x^2]/x^2, x, 4, -(Sqrt[2 - x - x^2]/x) + ArcSin[(1/3)*(-1 - 2*x)] + ArcTanh[(4 - x)/(2*Sqrt[2]*Sqrt[2 - x - x^2])]/(2*Sqrt[2])}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^6/Sqrt[a + b*x + c*x^2], x, 7, -((b*(1155*b^4 - 4144*a*b^2*c + 2448*a^2*c^2)*Sqrt[a + b*x + c*x^2])/(2560*c^6)) - (b*(77*b^2 - 156*a*c)*x^2*Sqrt[a + b*x + c*x^2])/(320*c^4) + ((99*b^2 - 100*a*c)*x^3*Sqrt[a + b*x + c*x^2])/(480*c^3) - (11*b*x^4*Sqrt[a + b*x + c*x^2])/(60*c^2) + (x^5*Sqrt[a + b*x + c*x^2])/(6*c) + ((4*a*b*(77*b^2 - 156*a*c) + (385*b^4 - 1176*a*b^2*c + 400*a^2*c^2)*x)*Sqrt[a + b*x + c*x^2])/(1280*c^5) + ((231*b^6 - 1260*a*b^4*c + 1680*a^2*b^2*c^2 - 320*a^3*c^3)*ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])])/(1024*c^(13/2))}
{x^5/Sqrt[a + b*x + c*x^2], x, 6, ((945*b^4 - 2436*a*b^2*c + 512*a^2*c^2)*Sqrt[a + b*x + c*x^2])/(1920*c^5) + ((63*b^2 - 64*a*c)*x^2*Sqrt[a + b*x + c*x^2])/(240*c^3) - (9*b*x^3*Sqrt[a + b*x + c*x^2])/(40*c^2) + (x^4*Sqrt[a + b*x + c*x^2])/(5*c) - ((4*a*(63*b^2 - 64*a*c) + 7*b*(45*b^2 - 92*a*c)*x)*Sqrt[a + b*x + c*x^2])/(960*c^4) - (b*(63*b^4 - 280*a*b^2*c + 240*a^2*c^2)*ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])])/(256*c^(11/2))}
{x^4/Sqrt[a + b*x + c*x^2], x, 5, -((b*(105*b^2 - 164*a*c)*Sqrt[a + b*x + c*x^2])/(192*c^4)) - (7*b*x^2*Sqrt[a + b*x + c*x^2])/(24*c^2) + (x^3*Sqrt[a + b*x + c*x^2])/(4*c) + ((28*a*b + (35*b^2 - 36*a*c)*x)*Sqrt[a + b*x + c*x^2])/(96*c^3) + ((35*b^4 - 120*a*b^2*c + 48*a^2*c^2)*ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])])/(128*c^(9/2))}
{x^3/Sqrt[a + b*x + c*x^2], x, 4, ((15*b^2 - 8*a*c)*Sqrt[a + b*x + c*x^2])/(24*c^3) + (x^2*Sqrt[a + b*x + c*x^2])/(3*c) - ((4*a + 5*b*x)*Sqrt[a + b*x + c*x^2])/(12*c^2) - (b*(5*b^2 - 12*a*c)*ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])])/(16*c^(7/2))}
{x^2/Sqrt[a + b*x + c*x^2], x, 3, -((3*b*Sqrt[a + b*x + c*x^2])/(4*c^2)) + (x*Sqrt[a + b*x + c*x^2])/(2*c) + ((3*b^2 - 4*a*c)*ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])])/(8*c^(5/2))}
{x^1/Sqrt[a + b*x + c*x^2], x, 2, Sqrt[a + b*x + c*x^2]/c - (b*ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])])/(2*c^(3/2))}
{x^0/Sqrt[a + b*x + c*x^2], x, 1, ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])]/Sqrt[c]}
{1/(x^1*Sqrt[a + b*x + c*x^2]), x, 1, -(ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])]/Sqrt[a])}
{1/(x^2*Sqrt[a + b*x + c*x^2]), x, 2, -(Sqrt[a + b*x + c*x^2]/(a*x)) + (b*ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])])/(2*a^(3/2))}
{1/(x^3*Sqrt[a + b*x + c*x^2]), x, 4, -(Sqrt[a + b*x + c*x^2]/(2*a*x^2)) + (3*b*Sqrt[a + b*x + c*x^2])/(4*a^2*x) - ((3*b^2 - 4*a*c)*ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])])/(8*a^(5/2))}
{1/(x^4*Sqrt[a + b*x + c*x^2]), x, 5, -(Sqrt[a + b*x + c*x^2]/(3*a*x^3)) + (5*b*Sqrt[a + b*x + c*x^2])/(12*a^2*x^2) - ((15*b^2 - 16*a*c)*Sqrt[a + b*x + c*x^2])/(24*a^3*x) + (b*(5*b^2 - 12*a*c)*ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])])/(16*a^(7/2))}
{1/(x^5*Sqrt[a + b*x + c*x^2]), x, 6, -(Sqrt[a + b*x + c*x^2]/(4*a*x^4)) + (7*b*Sqrt[a + b*x + c*x^2])/(24*a^2*x^3) - ((35*b^2 - 36*a*c)*Sqrt[a + b*x + c*x^2])/(96*a^3*x^2) + (5*b*(21*b^2 - 44*a*c)*Sqrt[a + b*x + c*x^2])/(192*a^4*x) - ((35*b^4 - 120*a*b^2*c + 48*a^2*c^2)*ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])])/(128*a^(9/2))}
{1/(x^6*Sqrt[a + b*x + c*x^2]), x, 7, -(Sqrt[a + b*x + c*x^2]/(5*a*x^5)) + (9*b*Sqrt[a + b*x + c*x^2])/(40*a^2*x^4) - ((63*b^2 - 64*a*c)*Sqrt[a + b*x + c*x^2])/(240*a^3*x^3) + (7*b*(45*b^2 - 92*a*c)*Sqrt[a + b*x + c*x^2])/(960*a^4*x^2) - ((945*b^4 - 2940*a*b^2*c + 1024*a^2*c^2)*Sqrt[a + b*x + c*x^2])/(1920*a^5*x) + (b*(63*b^4 - 280*a*b^2*c + 240*a^2*c^2)*ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])])/(256*a^(11/2))}


{x^3/Sqrt[a + b*x - c*x^2], x, 4, -(((15*b^2 + 8*a*c)*Sqrt[a + b*x - c*x^2])/(24*c^3)) - (x^2*Sqrt[a + b*x - c*x^2])/(3*c) - ((4*a + 5*b*x)*Sqrt[a + b*x - c*x^2])/(12*c^2) - (b*(5*b^2 + 12*a*c)*ArcTan[(b - 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x - c*x^2])])/(16*c^(7/2))}
{x^2/Sqrt[a + b*x - c*x^2], x, 3, -((3*b*Sqrt[a + b*x - c*x^2])/(4*c^2)) - (x*Sqrt[a + b*x - c*x^2])/(2*c) - ((3*b^2 + 4*a*c)*ArcTan[(b - 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x - c*x^2])])/(8*c^(5/2))}
{x^1/Sqrt[a + b*x - c*x^2], x, 2, -(Sqrt[a + b*x - c*x^2]/c) - (b*ArcTan[(b - 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x - c*x^2])])/(2*c^(3/2))}
{x^0/Sqrt[a + b*x - c*x^2], x, 1, -(ArcTan[(b - 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x - c*x^2])]/Sqrt[c])}
{1/(x^1*Sqrt[-a + b*x + c*x^2]), x, 1, -(ArcTan[(2*a - b*x)/(2*Sqrt[a]*Sqrt[-a + b*x + c*x^2])]/Sqrt[a])}
{1/(x^2*Sqrt[-a + b*x + c*x^2]), x, 2, Sqrt[-a + b*x + c*x^2]/(a*x) - (b*ArcTan[(2*a - b*x)/(2*Sqrt[a]*Sqrt[-a + b*x + c*x^2])])/(2*a^(3/2))}
{1/(x^3*Sqrt[-a + b*x + c*x^2]), x, 4, Sqrt[-a + b*x + c*x^2]/(2*a*x^2) + (3*b*Sqrt[-a + b*x + c*x^2])/(4*a^2*x) - ((3*b^2 + 4*a*c)*ArcTan[(2*a - b*x)/(2*Sqrt[a]*Sqrt[-a + b*x + c*x^2])])/(8*a^(5/2))}


{x^3/(a + b*x + c*x^2)^(3/2), x, 4, (2*x^2*(2*a + b*x))/((b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2]) + ((3*b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2])/(c^2*(b^2 - 4*a*c)) - (2*(2*a + b*x)*Sqrt[a + b*x + c*x^2])/(c*(b^2 - 4*a*c)) - (3*b*ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])])/(2*c^(5/2))}
{x^2/(a + b*x + c*x^2)^(3/2), x, 3, (2*x*(2*a + b*x))/((b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2]) - (2*b*Sqrt[a + b*x + c*x^2])/(c*(b^2 - 4*a*c)) + ArcTanh[(b + 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x + c*x^2])]/c^(3/2)}
{x/(a + b*x + c*x^2)^(3/2), x, 1, (2*(2*a + b*x))/((b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2])}
{1/(a + b*x + c*x^2)^(3/2), x, 1, -((2*(b + 2*c*x))/((b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2]))}
{1/(x*(a + b*x + c*x^2)^(3/2)), x, 2, (2*(b^2 - 2*a*c + b*c*x))/(a*(b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2]) - ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])]/a^(3/2)}
{1/(x^2*(a + b*x + c*x^2)^(3/2)), x, 4, (2*(b^2 - 2*a*c + b*c*x))/(a*(b^2 - 4*a*c)*x*Sqrt[a + b*x + c*x^2]) - ((3*b^2 - 8*a*c)*Sqrt[a + b*x + c*x^2])/(a^2*(b^2 - 4*a*c)*x) + (3*b*ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])])/(2*a^(5/2))}
{1/(x^3*(a + b*x + c*x^2)^(3/2)), x, 5, (2*(b^2 - 2*a*c + b*c*x))/(a*(b^2 - 4*a*c)*x^2*Sqrt[a + b*x + c*x^2]) - ((5*b^2 - 12*a*c)*Sqrt[a + b*x + c*x^2])/(2*a^2*(b^2 - 4*a*c)*x^2) + (b*(15*b^2 - 52*a*c)*Sqrt[a + b*x + c*x^2])/(4*a^3*(b^2 - 4*a*c)*x) - (3*(5*b^2 - 4*a*c)*ArcTanh[(2*a + b*x)/(2*Sqrt[a]*Sqrt[a + b*x + c*x^2])])/(8*a^(7/2))}


{x^3/(a + b*x - c*x^2)^(3/2), x, 4, (2*x^2*(2*a + b*x))/((b^2 + 4*a*c)*Sqrt[a + b*x - c*x^2]) + ((3*b^2 + 4*a*c)*Sqrt[a + b*x - c*x^2])/(c^2*(b^2 + 4*a*c)) + (2*(2*a + b*x)*Sqrt[a + b*x - c*x^2])/(c*(b^2 + 4*a*c)) + (3*b*ArcTan[(b - 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x - c*x^2])])/(2*c^(5/2))}
{x^2/(a + b*x - c*x^2)^(3/2), x, 3, (2*x*(2*a + b*x))/((b^2 + 4*a*c)*Sqrt[a + b*x - c*x^2]) + (2*b*Sqrt[a + b*x - c*x^2])/(c*(b^2 + 4*a*c)) + ArcTan[(b - 2*c*x)/(2*Sqrt[c]*Sqrt[a + b*x - c*x^2])]/c^(3/2)}
{x/(a + b*x - c*x^2)^(3/2), x, 1, (2*(2*a + b*x))/((b^2 + 4*a*c)*Sqrt[a + b*x - c*x^2])}
{1/(a + b*x - c*x^2)^(3/2), x, 1, -((2*(b - 2*c*x))/((b^2 + 4*a*c)*Sqrt[a + b*x - c*x^2]))}
{1/(x*(-a + b*x + c*x^2)^(3/2)), x, 2, -((2*(b^2 + 2*a*c + b*c*x))/(a*(b^2 + 4*a*c)*Sqrt[-a + b*x + c*x^2])) + ArcTan[(2*a - b*x)/(2*Sqrt[a]*Sqrt[-a + b*x + c*x^2])]/a^(3/2)}
{1/(x^2*(-a + b*x + c*x^2)^(3/2)), x, 4, -((2*(b^2 + 2*a*c + b*c*x))/(a*(b^2 + 4*a*c)*x*Sqrt[-a + b*x + c*x^2])) - ((3*b^2 + 8*a*c)*Sqrt[-a + b*x + c*x^2])/(a^2*(b^2 + 4*a*c)*x) + (3*b*ArcTan[(2*a - b*x)/(2*Sqrt[a]*Sqrt[-a + b*x + c*x^2])])/(2*a^(5/2))}
{1/(x^3*(-a + b*x + c*x^2)^(3/2)), x, 5, -((2*(b^2 + 2*a*c + b*c*x))/(a*(b^2 + 4*a*c)*x^2*Sqrt[-a + b*x + c*x^2])) - ((5*b^2 + 12*a*c)*Sqrt[-a + b*x + c*x^2])/(2*a^2*(b^2 + 4*a*c)*x^2) - (b*(15*b^2 + 52*a*c)*Sqrt[-a + b*x + c*x^2])/(4*a^3*(b^2 + 4*a*c)*x) + (3*(5*b^2 + 4*a*c)*ArcTan[(2*a - b*x)/(2*Sqrt[a]*Sqrt[-a + b*x + c*x^2])])/(8*a^(7/2))}


(* Integrands of the form 1/Sqrt[a+b*x+c*x^2] *)
{1/Sqrt[5 - 6*x + 9*x^2], x, 1, ArcSinh[(-1 + 3*x)/2]/3}
{1/Sqrt[3 - 4*x - 4*x^2], x, 1, ArcSin[1/2 + x]/2, (-(1/2))*ArcSin[(1/2)*(-1 - 2*x)]}
{1/Sqrt[-8 + 6*x + 9*x^2], x, 1, (1/3)*ArcTanh[(1 + 3*x)/Sqrt[-8 + 6*x + 9*x^2]]}
{1/Sqrt[2 + 4*x + 3*x^2], x, 1, ArcSinh[(2 + 3*x)/Sqrt[2]]/Sqrt[3]}
{1/Sqrt[2 + 4*x - 3*x^2], x, 1, -(ArcSin[(2 - 3*x)/Sqrt[10]]/Sqrt[3])}
{1/Sqrt[2 + 5*x + 3*x^2], x, 1, ArcTanh[(5 + 6*x)/(2*Sqrt[3]*Sqrt[2 + 5*x + 3*x^2])]/Sqrt[3]}
{1/Sqrt[2 + 5*x - 3*x^2], x, 1, -(ArcSin[(5 - 6*x)/7]/Sqrt[3])}
{1/Sqrt[-2 + 4*x + 3*x^2], x, 1, ArcTanh[(2 + 3*x)/(Sqrt[3]*Sqrt[-2 + 4*x + 3*x^2])]/Sqrt[3]}
{1/Sqrt[-2 + 4*x - 3*x^2], x, 1, -(ArcTan[(2 - 3*x)/(Sqrt[3]*Sqrt[-2 + 4*x - 3*x^2])]/Sqrt[3])}
{1/Sqrt[-2 + 5*x + 3*x^2], x, 1, ArcTanh[(5 + 6*x)/(2*Sqrt[3]*Sqrt[-2 + 5*x + 3*x^2])]/Sqrt[3]}
{1/Sqrt[-2 + 5*x - 3*x^2], x, 1, -(ArcSin[5 - 6*x]/Sqrt[3])}

{1/Sqrt[(4*c + b^2)/(4*c) + b*x + c*x^2], x, 1, ArcSinh[(b + 2*c*x)/(2*Sqrt[c])]/Sqrt[c]}
{1/Sqrt[(4*c - b^2)/(4*c) + b*x - c*x^2], x, 1, -(ArcSin[(b - 2*c*x)/(2*Sqrt[c])]/Sqrt[c])}
{1/Sqrt[(c - b^2)/(4*c) + b*x - c*x^2], x, 1, -(ArcSin[(b - 2*c*x)/Sqrt[c]]/Sqrt[c])}


{x/Sqrt[2 + 4*x + 3*x^2], x, 2, (1/3)*Sqrt[2 + 4*x + 3*x^2] - (2*ArcSinh[(2 + 3*x)/Sqrt[2]])/(3*Sqrt[3])}
{x/Sqrt[2 + 4*x - 3*x^2], x, 2, (-(1/3))*Sqrt[2 + 4*x - 3*x^2] - (2*ArcSin[(2 - 3*x)/Sqrt[10]])/(3*Sqrt[3])}
{x/Sqrt[2 + 5*x + 3*x^2], x, 2, (1/3)*Sqrt[2 + 5*x + 3*x^2] - (5*ArcTanh[(5 + 6*x)/(2*Sqrt[3]*Sqrt[2 + 5*x + 3*x^2])])/(6*Sqrt[3])}
{x/Sqrt[2 + 5*x - 3*x^2], x, 2, (-(1/3))*Sqrt[2 + 5*x - 3*x^2] - (5*ArcSin[(1/7)*(5 - 6*x)])/(6*Sqrt[3])}
{x/Sqrt[-2 + 4*x + 3*x^2], x, 2, (1/3)*Sqrt[-2 + 4*x + 3*x^2] - (2*ArcTanh[(2 + 3*x)/(Sqrt[3]*Sqrt[-2 + 4*x + 3*x^2])])/(3*Sqrt[3])}
{x/Sqrt[-2 + 4*x - 3*x^2], x, 2, (-(1/3))*Sqrt[-2 + 4*x - 3*x^2] - (2*ArcTan[(2 - 3*x)/(Sqrt[3]*Sqrt[-2 + 4*x - 3*x^2])])/(3*Sqrt[3])}
{x/Sqrt[-2 + 5*x + 3*x^2], x, 2, (1/3)*Sqrt[-2 + 5*x + 3*x^2] - (5*ArcTanh[(5 + 6*x)/(2*Sqrt[3]*Sqrt[-2 + 5*x + 3*x^2])])/(6*Sqrt[3])}
{x/Sqrt[-2 + 5*x - 3*x^2], x, 2, (-(1/3))*Sqrt[-2 + 5*x - 3*x^2] - (5*ArcSin[5 - 6*x])/(6*Sqrt[3])}


{1/(x*Sqrt[4 + 12*x + 9*x^2]), x, 3, -(((2 + 3*x)*ArcTanh[1 + 3*x])/Sqrt[4 + 12*x + 9*x^2]), ((2 + 3*x)*Log[x])/(2*Sqrt[4 + 12*x + 9*x^2]) - ((2 + 3*x)*Log[2 + 3*x])/(2*Sqrt[4 + 12*x + 9*x^2])}
{1/(x*Sqrt[4 - 12*x + 9*x^2]), x, 3, -(((2 - 3*x)*ArcTanh[1 - 3*x])/Sqrt[4 - 12*x + 9*x^2]), -(((2 - 3*x)*Log[2 - 3*x])/(2*Sqrt[4 - 12*x + 9*x^2])) + ((2 - 3*x)*Log[x])/(2*Sqrt[4 - 12*x + 9*x^2])}
{1/(x*Sqrt[-4 + 12*x - 9*x^2]), x, 3, -(((2 - 3*x)*ArcTanh[1 - 3*x])/Sqrt[-4 + 12*x - 9*x^2]), -(((2 - 3*x)*Log[2 - 3*x])/(2*Sqrt[-4 + 12*x - 9*x^2])) + ((2 - 3*x)*Log[x])/(2*Sqrt[-4 + 12*x - 9*x^2])}
{1/(x*Sqrt[-4 - 12*x - 9*x^2]), x, 3, -(((2 + 3*x)*ArcTanh[1 + 3*x])/Sqrt[-4 - 12*x - 9*x^2]), ((2 + 3*x)*Log[x])/(2*Sqrt[-4 - 12*x - 9*x^2]) - ((2 + 3*x)*Log[2 + 3*x])/(2*Sqrt[-4 - 12*x - 9*x^2])}

{1/(x*Sqrt[a^2 + 2*a*b*x + b^2*x^2]), x, 3, ((a + b*x)*Log[x])/(a*Sqrt[a^2 + 2*a*b*x + b^2*x^2]) - ((a + b*x)*Log[a + b*x])/(a*Sqrt[a^2 + 2*a*b*x + b^2*x^2])}
{1/(x*Sqrt[a^2 - 2*a*b*x + b^2*x^2]), x, 3, ((a - b*x)*Log[x])/(a*Sqrt[a^2 - 2*a*b*x + b^2*x^2]) - ((a - b*x)*Log[a - b*x])/(a*Sqrt[a^2 - 2*a*b*x + b^2*x^2])}
{1/(x*Sqrt[-a^2 + 2*a*b*x - b^2*x^2]), x, 3, ((a - b*x)*Log[x])/(a*Sqrt[-a^2 + 2*a*b*x - b^2*x^2]) - ((a - b*x)*Log[a - b*x])/(a*Sqrt[-a^2 + 2*a*b*x - b^2*x^2])}
{1/(x*Sqrt[-a^2 - 2*a*b*x - b^2*x^2]), x, 3, ((a + b*x)*Log[x])/(a*Sqrt[-a^2 - 2*a*b*x - b^2*x^2]) - ((a + b*x)*Log[a + b*x])/(a*Sqrt[-a^2 - 2*a*b*x - b^2*x^2])}


{1/(x*Sqrt[2 + 4*x + 3*x^2]), x, 1, -(ArcTanh[(Sqrt[2]*(1 + x))/Sqrt[2 + 4*x + 3*x^2]]/Sqrt[2])}
{1/(x*Sqrt[2 + 4*x - 3*x^2]), x, 1, -(ArcTanh[(Sqrt[2]*(1 + x))/Sqrt[2 + 4*x - 3*x^2]]/Sqrt[2])}
{1/(x*Sqrt[2 + 5*x + 3*x^2]), x, 1, -(ArcTanh[(4 + 5*x)/(2*Sqrt[2]*Sqrt[2 + 5*x + 3*x^2])]/Sqrt[2])}
{1/(x*Sqrt[2 + 5*x - 3*x^2]), x, 1, -(ArcTanh[(4 + 5*x)/(2*Sqrt[2]*Sqrt[2 + 5*x - 3*x^2])]/Sqrt[2])}
{1/(x*Sqrt[-2 + 4*x + 3*x^2]), x, 1, -(ArcTan[(Sqrt[2]*(1 - x))/Sqrt[-2 + 4*x + 3*x^2]]/Sqrt[2])}
{1/(x*Sqrt[-2 + 4*x - 3*x^2]), x, 1, -(ArcTan[(Sqrt[2]*(1 - x))/Sqrt[-2 + 4*x - 3*x^2]]/Sqrt[2])}
{1/(x*Sqrt[-2 + 5*x + 3*x^2]), x, 1, -(ArcTan[(4 - 5*x)/(2*Sqrt[2]*Sqrt[-2 + 5*x + 3*x^2])]/Sqrt[2])}
{1/(x*Sqrt[-2 + 5*x - 3*x^2]), x, 1, -(ArcTan[(4 - 5*x)/(2*Sqrt[2]*Sqrt[-2 + 5*x - 3*x^2])]/Sqrt[2])}


{1/(x^3*Sqrt[1 + x + x^2]), x, 4, -(Sqrt[1 + x + x^2]/(2*x^2)) + (3*Sqrt[1 + x + x^2])/(4*x) + (1/8)*ArcTanh[(2 + x)/(2*Sqrt[1 + x + x^2])]}

{x*Sqrt[3 - 2*x - x^2], x, 3, (-(1/2))*(1 + x)*Sqrt[3 - 2*x - x^2] - (1/3)*(3 - 2*x - x^2)^(3/2) + 2*ArcSin[(1/2)*(-1 - x)]}
{x*Sqrt[8 + 2*x - x^2], x, 3, (-(1/2))*(1 - x)*Sqrt[8 + 2*x - x^2] - (1/3)*(8 + 2*x - x^2)^(3/2) - (9/2)*ArcSin[(1 - x)/3]}
{x*Sqrt[4 + 2*x + x^2], x, 3, (-(1/2))*(1 + x)*Sqrt[4 + 2*x + x^2] + (1/3)*(4 + 2*x + x^2)^(3/2) - (3/2)*ArcSinh[(1 + x)/Sqrt[3]]}


{1/(4 + 12*x + 9*x^2)^(3/2), x, 1, -((2 + 3*x)/(6*(4 + 12*x + 9*x^2)^(3/2)))}
{1/(2 + 3*x + x^2)^(3/2), x, 1, (-2*(3 + 2*x))/Sqrt[2 + 3*x + x^2]}
{1/(27 - 24*x + 4*x^2)^(3/2), x, 1, (3 - x)/(9*Sqrt[27 - 24*x + 4*x^2])}

{x/(5 - 4*x - x^2)^(3/2), x, 1, (5 - 2*x)/(9*Sqrt[5 - 4*x - x^2])}


{1/(5 - 4*x - x^2)^(5/2), x, 2, (2 + x)/(27*(5 - 4*x - x^2)^(3/2)) + (2*(2 + x))/(243*Sqrt[5 - 4*x - x^2])}


{1/x - 1/(x*Sqrt[1 + b*x + c*x^2]), x, 2, Log[-b*x - 2 - 2*Sqrt[1 + b*x + c*x^2]], ArcTanh[(2 + b*x)/(2*Sqrt[1 + b*x + c*x^2])] + Log[x]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a+b x+c x^2)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^(7/2)*(a + b*x + c*x^2), x, 2, (2/9)*a*x^(9/2) + (2/11)*b*x^(11/2) + (2/13)*c*x^(13/2)}
{x^(5/2)*(a + b*x + c*x^2), x, 2, (2/7)*a*x^(7/2) + (2/9)*b*x^(9/2) + (2/11)*c*x^(11/2)}
{x^(3/2)*(a + b*x + c*x^2), x, 2, (2/5)*a*x^(5/2) + (2/7)*b*x^(7/2) + (2/9)*c*x^(9/2)}
{x^(1/2)*(a + b*x + c*x^2), x, 2, (2/3)*a*x^(3/2) + (2/5)*b*x^(5/2) + (2/7)*c*x^(7/2)}
{(a + b*x + c*x^2)/x^(1/2), x, 2, 2*a*Sqrt[x] + (2/3)*b*x^(3/2) + (2/5)*c*x^(5/2)}
{(a + b*x + c*x^2)/x^(3/2), x, 2, -((2*a)/Sqrt[x]) + 2*b*Sqrt[x] + (2/3)*c*x^(3/2)}
{(a + b*x + c*x^2)/x^(5/2), x, 2, -((2*a)/(3*x^(3/2))) - (2*b)/Sqrt[x] + 2*c*Sqrt[x]}
{(a + b*x + c*x^2)/x^(7/2), x, 2, -((2*a)/(5*x^(5/2))) - (2*b)/(3*x^(3/2)) - (2*c)/Sqrt[x]}


{x^(7/2)*(a + b*x + c*x^2)^2, x, 2, (2/9)*a^2*x^(9/2) + (4/11)*a*b*x^(11/2) + (2/13)*(b^2 + 2*a*c)*x^(13/2) + (4/15)*b*c*x^(15/2) + (2/17)*c^2*x^(17/2)}
{x^(5/2)*(a + b*x + c*x^2)^2, x, 2, (2/7)*a^2*x^(7/2) + (4/9)*a*b*x^(9/2) + (2/11)*(b^2 + 2*a*c)*x^(11/2) + (4/13)*b*c*x^(13/2) + (2/15)*c^2*x^(15/2)}
{x^(3/2)*(a + b*x + c*x^2)^2, x, 2, (2/5)*a^2*x^(5/2) + (4/7)*a*b*x^(7/2) + (2/9)*(b^2 + 2*a*c)*x^(9/2) + (4/11)*b*c*x^(11/2) + (2/13)*c^2*x^(13/2)}
{x^(1/2)*(a + b*x + c*x^2)^2, x, 2, (2/3)*a^2*x^(3/2) + (4/5)*a*b*x^(5/2) + (2/7)*(b^2 + 2*a*c)*x^(7/2) + (4/9)*b*c*x^(9/2) + (2/11)*c^2*x^(11/2)}
{(a + b*x + c*x^2)^2/x^(1/2), x, 2, 2*a^2*Sqrt[x] + (4/3)*a*b*x^(3/2) + (2/5)*(b^2 + 2*a*c)*x^(5/2) + (4/7)*b*c*x^(7/2) + (2/9)*c^2*x^(9/2)}
{(a + b*x + c*x^2)^2/x^(3/2), x, 2, -((2*a^2)/Sqrt[x]) + 4*a*b*Sqrt[x] + (2/3)*(b^2 + 2*a*c)*x^(3/2) + (4/5)*b*c*x^(5/2) + (2/7)*c^2*x^(7/2)}
{(a + b*x + c*x^2)^2/x^(5/2), x, 2, -((2*a^2)/(3*x^(3/2))) - (4*a*b)/Sqrt[x] + 2*(b^2 + 2*a*c)*Sqrt[x] + (4/3)*b*c*x^(3/2) + (2/5)*c^2*x^(5/2)}
{(a + b*x + c*x^2)^2/x^(7/2), x, 2, -((2*a^2)/(5*x^(5/2))) - (4*a*b)/(3*x^(3/2)) - (2*(b^2 + 2*a*c))/Sqrt[x] + 4*b*c*Sqrt[x] + (2/3)*c^2*x^(3/2)}


{x^(5/2)*(a + b*x + c*x^2)^3, x, 2, (2/7)*a^3*x^(7/2) + (2/3)*a^2*b*x^(9/2) + (6/11)*a*(b^2 + a*c)*x^(11/2) + (2/13)*b*(b^2 + 6*a*c)*x^(13/2) + (2/5)*c*(b^2 + a*c)*x^(15/2) + (6/17)*b*c^2*x^(17/2) + (2/19)*c^3*x^(19/2)}
{x^(3/2)*(a + b*x + c*x^2)^3, x, 2, (2/5)*a^3*x^(5/2) + (6/7)*a^2*b*x^(7/2) + (2/3)*a*(b^2 + a*c)*x^(9/2) + (2/11)*b*(b^2 + 6*a*c)*x^(11/2) + (6/13)*c*(b^2 + a*c)*x^(13/2) + (2/5)*b*c^2*x^(15/2) + (2/17)*c^3*x^(17/2)}
{x^(1/2)*(a + b*x + c*x^2)^3, x, 2, (2/3)*a^3*x^(3/2) + (6/5)*a^2*b*x^(5/2) + (6/7)*a*(b^2 + a*c)*x^(7/2) + (2/9)*b*(b^2 + 6*a*c)*x^(9/2) + (6/11)*c*(b^2 + a*c)*x^(11/2) + (6/13)*b*c^2*x^(13/2) + (2/15)*c^3*x^(15/2)}
{(a + b*x + c*x^2)^3/x^(1/2), x, 2, 2*a^3*Sqrt[x] + 2*a^2*b*x^(3/2) + (6/5)*a*(b^2 + a*c)*x^(5/2) + (2/7)*b*(b^2 + 6*a*c)*x^(7/2) + (2/3)*c*(b^2 + a*c)*x^(9/2) + (6/11)*b*c^2*x^(11/2) + (2/13)*c^3*x^(13/2)}
{(a + b*x + c*x^2)^3/x^(3/2), x, 2, -((2*a^3)/Sqrt[x]) + 6*a^2*b*Sqrt[x] + 2*a*(b^2 + a*c)*x^(3/2) + (2/5)*b*(b^2 + 6*a*c)*x^(5/2) + (6/7)*c*(b^2 + a*c)*x^(7/2) + (2/3)*b*c^2*x^(9/2) + (2/11)*c^3*x^(11/2)}
{(a + b*x + c*x^2)^3/x^(5/2), x, 2, -((2*a^3)/(3*x^(3/2))) - (6*a^2*b)/Sqrt[x] + 6*a*(b^2 + a*c)*Sqrt[x] + (2/3)*b*(b^2 + 6*a*c)*x^(3/2) + (6/5)*c*(b^2 + a*c)*x^(5/2) + (6/7)*b*c^2*x^(7/2) + (2/9)*c^3*x^(9/2)}
{(a + b*x + c*x^2)^3/x^(7/2), x, 2, -((2*a^3)/(5*x^(5/2))) - (2*a^2*b)/x^(3/2) - (6*a*(b^2 + a*c))/Sqrt[x] + 2*b*(b^2 + 6*a*c)*Sqrt[x] + 2*c*(b^2 + a*c)*x^(3/2) + (6/5)*b*c^2*x^(5/2) + (2/7)*c^3*x^(7/2)}
{(a + b*x + c*x^2)^3/x^(9/2), x, 2, -((2*a^3)/(7*x^(7/2))) - (6*a^2*b)/(5*x^(5/2)) - (2*a*(b^2 + a*c))/x^(3/2) - (2*b*(b^2 + 6*a*c))/Sqrt[x] + 6*c*(b^2 + a*c)*Sqrt[x] + 2*b*c^2*x^(3/2) + (2/5)*c^3*x^(5/2)}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^(5/2)/(a + b*x + c*x^2), x, 5, -((2*b*Sqrt[x])/c^2) + (2*x^(3/2))/(3*c) - (Sqrt[2]*(b^3 - 3*a*b*c - Sqrt[b^2 - 4*a*c]*(b^2 - a*c))*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b - Sqrt[b^2 - 4*a*c]]])/(c^(5/2)*Sqrt[b^2 - 4*a*c]*Sqrt[b - Sqrt[b^2 - 4*a*c]]) + (Sqrt[2]*(b^3 - 3*a*b*c + Sqrt[b^2 - 4*a*c]*(b^2 - a*c))*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b + Sqrt[b^2 - 4*a*c]]])/(c^(5/2)*Sqrt[b^2 - 4*a*c]*Sqrt[b + Sqrt[b^2 - 4*a*c]])}
{x^(3/2)/(a + b*x + c*x^2), x, 4, (2*Sqrt[x])/c + (Sqrt[2]*(b^2 - 2*a*c - b*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b - Sqrt[b^2 - 4*a*c]]])/(c^(3/2)*Sqrt[b^2 - 4*a*c]*Sqrt[b - Sqrt[b^2 - 4*a*c]]) - (Sqrt[2]*(b^2 - 2*a*c + b*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b + Sqrt[b^2 - 4*a*c]]])/(c^(3/2)*Sqrt[b^2 - 4*a*c]*Sqrt[b + Sqrt[b^2 - 4*a*c]])}
{x^(1/2)/(a + b*x + c*x^2), x, 3, -((Sqrt[2]*Sqrt[b - Sqrt[b^2 - 4*a*c]]*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b - Sqrt[b^2 - 4*a*c]]])/(Sqrt[c]*Sqrt[b^2 - 4*a*c])) + (Sqrt[2]*Sqrt[b + Sqrt[b^2 - 4*a*c]]*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b + Sqrt[b^2 - 4*a*c]]])/(Sqrt[c]*Sqrt[b^2 - 4*a*c])}
{x^(-1/2)/(a + b*x + c*x^2), x, 3, (2*Sqrt[2]*Sqrt[c]*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b - Sqrt[b^2 - 4*a*c]]])/(Sqrt[b^2 - 4*a*c]*Sqrt[b - Sqrt[b^2 - 4*a*c]]) - (2*Sqrt[2]*Sqrt[c]*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b + Sqrt[b^2 - 4*a*c]]])/(Sqrt[b^2 - 4*a*c]*Sqrt[b + Sqrt[b^2 - 4*a*c]])}
{x^(-3/2)/(a + b*x + c*x^2), x, 4, -(2/(a*Sqrt[x])) - (Sqrt[2]*Sqrt[c]*(b + Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b - Sqrt[b^2 - 4*a*c]]])/(a*Sqrt[b^2 - 4*a*c]*Sqrt[b - Sqrt[b^2 - 4*a*c]]) + (Sqrt[2]*Sqrt[c]*(b - Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b + Sqrt[b^2 - 4*a*c]]])/(a*Sqrt[b^2 - 4*a*c]*Sqrt[b + Sqrt[b^2 - 4*a*c]])}
{x^(-5/2)/(a + b*x + c*x^2), x, 5, -(2/(3*a*x^(3/2))) + (2*b)/(a^2*Sqrt[x]) + (Sqrt[2]*Sqrt[c]*(b^2 - 2*a*c + b*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b - Sqrt[b^2 - 4*a*c]]])/(a^2*Sqrt[b^2 - 4*a*c]*Sqrt[b - Sqrt[b^2 - 4*a*c]]) - (Sqrt[2]*Sqrt[c]*(b^2 - 2*a*c - b*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b + Sqrt[b^2 - 4*a*c]]])/(a^2*Sqrt[b^2 - 4*a*c]*Sqrt[b + Sqrt[b^2 - 4*a*c]])}


{x^(7/2)/(a + b*x + c*x^2)^2, x, 6, ((3*b^2 - 10*a*c)*Sqrt[x])/(c^2*(b^2 - 4*a*c)) - (b*x^(3/2))/(c*(b^2 - 4*a*c)) + (x^(5/2)*(2*a + b*x))/((b^2 - 4*a*c)*(a + b*x + c*x^2)) + ((3*b^4 - 19*a*b^2*c + 20*a^2*c^2 - b*(3*b^2 - 13*a*c)*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b - Sqrt[b^2 - 4*a*c]]])/(Sqrt[2]*c^(5/2)*(b^2 - 4*a*c)^(3/2)*Sqrt[b - Sqrt[b^2 - 4*a*c]]) - ((3*b^4 - 19*a*b^2*c + 20*a^2*c^2 + b*(3*b^2 - 13*a*c)*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b + Sqrt[b^2 - 4*a*c]]])/(Sqrt[2]*c^(5/2)*(b^2 - 4*a*c)^(3/2)*Sqrt[b + Sqrt[b^2 - 4*a*c]])}
{x^(5/2)/(a + b*x + c*x^2)^2, x, 5, -((b*Sqrt[x])/(c*(b^2 - 4*a*c))) + (x^(3/2)*(2*a + b*x))/((b^2 - 4*a*c)*(a + b*x + c*x^2)) - ((b^3 - 8*a*b*c - (b^2 - 6*a*c)*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b - Sqrt[b^2 - 4*a*c]]])/(Sqrt[2]*c^(3/2)*(b^2 - 4*a*c)^(3/2)*Sqrt[b - Sqrt[b^2 - 4*a*c]]) + ((b^3 - 8*a*b*c + (b^2 - 6*a*c)*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b + Sqrt[b^2 - 4*a*c]]])/(Sqrt[2]*c^(3/2)*(b^2 - 4*a*c)^(3/2)*Sqrt[b + Sqrt[b^2 - 4*a*c]])}
{x^(3/2)/(a + b*x + c*x^2)^2, x, 4, (Sqrt[x]*(2*a + b*x))/((b^2 - 4*a*c)*(a + b*x + c*x^2)) - ((b^2 + 4*a*c - b*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b - Sqrt[b^2 - 4*a*c]]])/(Sqrt[2]*Sqrt[c]*(b^2 - 4*a*c)^(3/2)*Sqrt[b - Sqrt[b^2 - 4*a*c]]) + ((b^2 + 4*a*c + b*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b + Sqrt[b^2 - 4*a*c]]])/(Sqrt[2]*Sqrt[c]*(b^2 - 4*a*c)^(3/2)*Sqrt[b + Sqrt[b^2 - 4*a*c]])}
{x^(1/2)/(a + b*x + c*x^2)^2, x, 4, -((Sqrt[x]*(b + 2*c*x))/((b^2 - 4*a*c)*(a + b*x + c*x^2))) + (Sqrt[2]*Sqrt[c]*(2*b - Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b - Sqrt[b^2 - 4*a*c]]])/((b^2 - 4*a*c)^(3/2)*Sqrt[b - Sqrt[b^2 - 4*a*c]]) - (Sqrt[2]*Sqrt[c]*(2*b + Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b + Sqrt[b^2 - 4*a*c]]])/((b^2 - 4*a*c)^(3/2)*Sqrt[b + Sqrt[b^2 - 4*a*c]])}
{x^(-1/2)/(a + b*x + c*x^2)^2, x, 4, (Sqrt[x]*(b^2 - 2*a*c + b*c*x))/(a*(b^2 - 4*a*c)*(a + b*x + c*x^2)) + (Sqrt[c]*(b^2 - 12*a*c + b*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b - Sqrt[b^2 - 4*a*c]]])/(Sqrt[2]*a*(b^2 - 4*a*c)^(3/2)*Sqrt[b - Sqrt[b^2 - 4*a*c]]) - (Sqrt[c]*(b^2 - 12*a*c - b*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b + Sqrt[b^2 - 4*a*c]]])/(Sqrt[2]*a*(b^2 - 4*a*c)^(3/2)*Sqrt[b + Sqrt[b^2 - 4*a*c]])}
{x^(-3/2)/(a + b*x + c*x^2)^2, x, 5, -((3*b^2 - 10*a*c)/(a^2*(b^2 - 4*a*c)*Sqrt[x])) + (b^2 - 2*a*c + b*c*x)/(a*(b^2 - 4*a*c)*Sqrt[x]*(a + b*x + c*x^2)) - (Sqrt[c]*(3*b^3 - 16*a*b*c + (3*b^2 - 10*a*c)*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b - Sqrt[b^2 - 4*a*c]]])/(Sqrt[2]*a^2*(b^2 - 4*a*c)^(3/2)*Sqrt[b - Sqrt[b^2 - 4*a*c]]) + (Sqrt[c]*(3*b^3 - 16*a*b*c - (3*b^2 - 10*a*c)*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b + Sqrt[b^2 - 4*a*c]]])/(Sqrt[2]*a^2*(b^2 - 4*a*c)^(3/2)*Sqrt[b + Sqrt[b^2 - 4*a*c]])}
{x^(-5/2)/(a + b*x + c*x^2)^2, x, 6, -((5*b^2 - 14*a*c)/(3*a^2*(b^2 - 4*a*c)*x^(3/2))) + (b*(5*b^2 - 19*a*c))/(a^3*(b^2 - 4*a*c)*Sqrt[x]) + (b^2 - 2*a*c + b*c*x)/(a*(b^2 - 4*a*c)*x^(3/2)*(a + b*x + c*x^2)) + (Sqrt[c]*(5*b^4 - 29*a*b^2*c + 28*a^2*c^2 + b*(5*b^2 - 19*a*c)*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b - Sqrt[b^2 - 4*a*c]]])/(Sqrt[2]*a^3*(b^2 - 4*a*c)^(3/2)*Sqrt[b - Sqrt[b^2 - 4*a*c]]) - (Sqrt[c]*(5*b^4 - 29*a*b^2*c + 28*a^2*c^2 - b*(5*b^2 - 19*a*c)*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b + Sqrt[b^2 - 4*a*c]]])/(Sqrt[2]*a^3*(b^2 - 4*a*c)^(3/2)*Sqrt[b + Sqrt[b^2 - 4*a*c]])}


{x^(9/2)/(a + b*x + c*x^2)^3, x, 7, -((3*b*(b^2 - 8*a*c)*Sqrt[x])/(4*c^2*(b^2 - 4*a*c)^2)) + ((b^2 - 28*a*c)*x^(3/2))/(4*c*(b^2 - 4*a*c)^2) + (x^(7/2)*(2*a + b*x))/(2*(b^2 - 4*a*c)*(a + b*x + c*x^2)^2) + (x^(5/2)*(12*a*b - (b^2 - 28*a*c)*x))/(4*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)) - (3*(b^5 - 11*a*b^3*c + 44*a^2*b*c^2 - Sqrt[b^2 - 4*a*c]*(b^4 - 9*a*b^2*c + 28*a^2*c^2))*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b - Sqrt[b^2 - 4*a*c]]])/(4*Sqrt[2]*c^(5/2)*(b^2 - 4*a*c)^(5/2)*Sqrt[b - Sqrt[b^2 - 4*a*c]]) + (3*(b^5 - 11*a*b^3*c + 44*a^2*b*c^2 + Sqrt[b^2 - 4*a*c]*(b^4 - 9*a*b^2*c + 28*a^2*c^2))*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b + Sqrt[b^2 - 4*a*c]]])/(4*Sqrt[2]*c^(5/2)*(b^2 - 4*a*c)^(5/2)*Sqrt[b + Sqrt[b^2 - 4*a*c]])}
{x^(7/2)/(a + b*x + c*x^2)^3, x, 6, -(((b^2 + 20*a*c)*Sqrt[x])/(4*c*(b^2 - 4*a*c)^2)) + (x^(5/2)*(2*a + b*x))/(2*(b^2 - 4*a*c)*(a + b*x + c*x^2)^2) + (x^(3/2)*(12*a*b + (b^2 + 20*a*c)*x))/(4*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)) - ((b^4 - 18*a*b^2*c - 40*a^2*c^2 - b*(b^2 - 16*a*c)*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b - Sqrt[b^2 - 4*a*c]]])/(4*Sqrt[2]*c^(3/2)*(b^2 - 4*a*c)^(5/2)*Sqrt[b - Sqrt[b^2 - 4*a*c]]) + ((b^4 - 18*a*b^2*c - 40*a^2*c^2 + b*(b^2 - 16*a*c)*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b + Sqrt[b^2 - 4*a*c]]])/(4*Sqrt[2]*c^(3/2)*(b^2 - 4*a*c)^(5/2)*Sqrt[b + Sqrt[b^2 - 4*a*c]])}
{x^(5/2)/(a + b*x + c*x^2)^3, x, 5, (x^(3/2)*(2*a + b*x))/(2*(b^2 - 4*a*c)*(a + b*x + c*x^2)^2) + (3*Sqrt[x]*(4*a*b + (b^2 + 4*a*c)*x))/(4*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)) - (3*(b^3 + 12*a*b*c - Sqrt[b^2 - 4*a*c]*(b^2 + 4*a*c))*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b - Sqrt[b^2 - 4*a*c]]])/(4*Sqrt[2]*Sqrt[c]*(b^2 - 4*a*c)^(5/2)*Sqrt[b - Sqrt[b^2 - 4*a*c]]) + (3*(b^3 + 12*a*b*c + Sqrt[b^2 - 4*a*c]*(b^2 + 4*a*c))*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b + Sqrt[b^2 - 4*a*c]]])/(4*Sqrt[2]*Sqrt[c]*(b^2 - 4*a*c)^(5/2)*Sqrt[b + Sqrt[b^2 - 4*a*c]])}
{x^(3/2)/(a + b*x + c*x^2)^3, x, 5, (Sqrt[x]*(2*a + b*x))/(2*(b^2 - 4*a*c)*(a + b*x + c*x^2)^2) - (Sqrt[x]*(7*b^2 - 4*a*c + 12*b*c*x))/(4*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)) + (3*Sqrt[c]*(3*b^2 + 4*a*c - 2*b*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b - Sqrt[b^2 - 4*a*c]]])/(2*Sqrt[2]*(b^2 - 4*a*c)^(5/2)*Sqrt[b - Sqrt[b^2 - 4*a*c]]) - (3*Sqrt[c]*(3*b^2 + 4*a*c + 2*b*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b + Sqrt[b^2 - 4*a*c]]])/(2*Sqrt[2]*(b^2 - 4*a*c)^(5/2)*Sqrt[b + Sqrt[b^2 - 4*a*c]])}
{x^(1/2)/(a + b*x + c*x^2)^3, x, 5, -((Sqrt[x]*(b + 2*c*x))/(2*(b^2 - 4*a*c)*(a + b*x + c*x^2)^2)) + (Sqrt[x]*(b*(b^2 + 8*a*c) + c*(b^2 + 20*a*c)*x))/(4*a*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)) + (Sqrt[c]*(b^3 - 52*a*b*c + Sqrt[b^2 - 4*a*c]*(b^2 + 20*a*c))*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b - Sqrt[b^2 - 4*a*c]]])/(4*Sqrt[2]*a*(b^2 - 4*a*c)^(5/2)*Sqrt[b - Sqrt[b^2 - 4*a*c]]) - (Sqrt[c]*(b^3 - 52*a*b*c - Sqrt[b^2 - 4*a*c]*(b^2 + 20*a*c))*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b + Sqrt[b^2 - 4*a*c]]])/(4*Sqrt[2]*a*(b^2 - 4*a*c)^(5/2)*Sqrt[b + Sqrt[b^2 - 4*a*c]])}
{x^(-1/2)/(a + b*x + c*x^2)^3, x, 5, (Sqrt[x]*(b^2 - 2*a*c + b*c*x))/(2*a*(b^2 - 4*a*c)*(a + b*x + c*x^2)^2) + (Sqrt[x]*((b^2 - 7*a*c)*(3*b^2 - 4*a*c) + 3*b*c*(b^2 - 8*a*c)*x))/(4*a^2*(b^2 - 4*a*c)^2*(a + b*x + c*x^2)) + (3*Sqrt[c]*(b^4 - 10*a*b^2*c + 56*a^2*c^2 + b*(b^2 - 8*a*c)*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b - Sqrt[b^2 - 4*a*c]]])/(4*Sqrt[2]*a^2*(b^2 - 4*a*c)^(5/2)*Sqrt[b - Sqrt[b^2 - 4*a*c]]) - (3*Sqrt[c]*(b^4 - 10*a*b^2*c + 56*a^2*c^2 - b*(b^2 - 8*a*c)*Sqrt[b^2 - 4*a*c])*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b + Sqrt[b^2 - 4*a*c]]])/(4*Sqrt[2]*a^2*(b^2 - 4*a*c)^(5/2)*Sqrt[b + Sqrt[b^2 - 4*a*c]])}
{x^(-3/2)/(a + b*x + c*x^2)^3, x, 6, -((3*(5*b^2 - 12*a*c)*(b^2 - 5*a*c))/(4*a^3*(b^2 - 4*a*c)^2*Sqrt[x])) + (b^2 - 2*a*c + b*c*x)/(2*a*(b^2 - 4*a*c)*Sqrt[x]*(a + b*x + c*x^2)^2) + (5*b^4 - 35*a*b^2*c + 36*a^2*c^2 + b*c*(5*b^2 - 32*a*c)*x)/(4*a^2*(b^2 - 4*a*c)^2*Sqrt[x]*(a + b*x + c*x^2)) + (3*Sqrt[c]*(b*(5*b^2 - 12*a*c)*(b^2 - 5*a*c) - (5*b^2 - 12*a*c)*(b^2 - 5*a*c)*Sqrt[b^2 - 4*a*c] - 2*b*(5*b^4 - 42*a*b^2*c + 92*a^2*c^2))*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b - Sqrt[b^2 - 4*a*c]]])/(4*Sqrt[2]*a^3*(b^2 - 4*a*c)^(5/2)*Sqrt[b - Sqrt[b^2 - 4*a*c]]) - (3*Sqrt[c]*(b*(5*b^2 - 12*a*c)*(b^2 - 5*a*c) + (5*b^2 - 12*a*c)*(b^2 - 5*a*c)*Sqrt[b^2 - 4*a*c] - 2*b*(5*b^4 - 42*a*b^2*c + 92*a^2*c^2))*ArcTan[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[b + Sqrt[b^2 - 4*a*c]]])/(4*Sqrt[2]*a^3*(b^2 - 4*a*c)^(5/2)*Sqrt[b + Sqrt[b^2 - 4*a*c]])}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a+b x+c x^2)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^(5/2)*Sqrt[a + b*x + c*x^2], x, 7, (2*Sqrt[x]*(b*(8*b^2 + 3*a*c) + 3*c*(8*b^2 - 7*a*c)*x)*Sqrt[a + b*x + c*x^2])/(315*c^3) - (4*b*Sqrt[x]*(a + b*x + c*x^2)^(3/2))/(21*c^2) + (2*x^(3/2)*(a + b*x + c*x^2)^(3/2))/(9*c) - (Sqrt[2]*(-(1/c))^(9/2)*(8*b^4 - 36*a*b^2*c + 21*a^2*c^2)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(315*Sqrt[a + b*x + c*x^2]) - (Sqrt[2]*(-b + Sqrt[b^2 - 4*a*c])^(3/2)*(8*b^4 - 36*a*b^2*c + 21*a^2*c^2 - (a*b*c*(8*b^2 - 27*a*c))/(b - Sqrt[b^2 - 4*a*c]))*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(315*c^(9/2)*Sqrt[a + b*x + c*x^2])}
{x^(3/2)*Sqrt[a + b*x + c*x^2], x, 6, -((2*Sqrt[x]*(4*b^2 + 5*a*c + 12*b*c*x)*Sqrt[a + b*x + c*x^2])/(105*c^2)) + (2*Sqrt[x]*(a + b*x + c*x^2)^(3/2))/(7*c) - (b*(-(1/c))^(7/2)*(8*b^2 - 29*a*c)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(105*Sqrt[2]*Sqrt[a + b*x + c*x^2]) - (Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(8*b^4 - 37*a*b^2*c + 20*a^2*c^2 - b*(8*b^2 - 29*a*c)*Sqrt[b^2 - 4*a*c])*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(105*Sqrt[2]*c^(7/2)*Sqrt[a + b*x + c*x^2])}
{Sqrt[x]*Sqrt[a + b*x + c*x^2], x, 6, (2*b*Sqrt[x]*Sqrt[a + b*x + c*x^2])/(15*c) + (2/5)*x^(3/2)*Sqrt[a + b*x + c*x^2] - (Sqrt[2]*(-(1/c))^(5/2)*(b^2 - 3*a*c)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(15*Sqrt[a + b*x + c*x^2]) + (Sqrt[2]*Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(b^3 - 4*a*b*c - Sqrt[b^2 - 4*a*c]*(b^2 - 3*a*c))*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(15*c^(5/2)*Sqrt[a + b*x + c*x^2])}
{Sqrt[a + b*x + c*x^2]/Sqrt[x], x, 5, (2*Sqrt[x]*Sqrt[a + b*x + c*x^2])/3 - (b*(-c^(-1))^(3/2)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-c^(-1)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(3*Sqrt[2]*Sqrt[a + b*x + c*x^2]) - (Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(b^2 - 4*a*c - b*Sqrt[b^2 - 4*a*c])*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(3*Sqrt[2]*c^(3/2)*Sqrt[a + b*x + c*x^2])}
{Sqrt[a + b*x + c*x^2]/x^(3/2), x, 5, (-2*Sqrt[a + b*x + c*x^2])/Sqrt[x] + (Sqrt[2]*Sqrt[-c^(-1)]*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-c^(-1)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/Sqrt[a + b*x + c*x^2] + (Sqrt[2]*Sqrt[b^2 - 4*a*c]*Sqrt[-b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(Sqrt[c]*Sqrt[a + b*x + c*x^2])}
{Sqrt[a + b*x + c*x^2]/x^(5/2), x, 6, (-2*Sqrt[a + b*x + c*x^2])/(3*x^(3/2)) - (2*b*Sqrt[a + b*x + c*x^2])/(3*a*Sqrt[x]) + (b*Sqrt[-c^(-1)]*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-c^(-1)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(3*Sqrt[2]*a*Sqrt[a + b*x + c*x^2]) - (Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(b^2 - 4*a*c - b*Sqrt[b^2 - 4*a*c])*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(3*Sqrt[2]*a*Sqrt[c]*Sqrt[a + b*x + c*x^2])}
{Sqrt[a + b*x + c*x^2]/x^(7/2), x, 7, (-2*Sqrt[a + b*x + c*x^2])/(5*x^(5/2)) - (2*b*Sqrt[a + b*x + c*x^2])/(15*a*x^(3/2)) + (4*(b^2 - 3*a*c)*Sqrt[a + b*x + c*x^2])/(15*a^2*Sqrt[x]) - (Sqrt[2]*Sqrt[-c^(-1)]*(b^2 - 3*a*c)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-c^(-1)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(15*a^2*Sqrt[a + b*x + c*x^2]) + (Sqrt[2]*Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(b^3 - 4*a*b*c - Sqrt[b^2 - 4*a*c]*(b^2 - 3*a*c))*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(15*a^2*Sqrt[c]*Sqrt[a + b*x + c*x^2])}


{x^(3/2)*(a + b*x + c*x^2)^(3/2), x, 7, (2*Sqrt[x]*(8*b^4 - 21*a*b^2*c - 30*a^2*c^2 + 3*b*c*(8*b^2 - 31*a*c)*x)*Sqrt[a + b*x + c*x^2])/(1155*c^3) - (2*Sqrt[x]*(3*(2*b^2 + a*c) + 14*b*c*x)*(a + b*x + c*x^2)^(3/2))/(231*c^2) + (2*Sqrt[x]*(a + b*x + c*x^2)^(5/2))/(11*c) - (4*Sqrt[2]*b*(-(1/c))^(9/2)*(2*b^2 - 9*a*c)*(b^2 - 3*a*c)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(1155*Sqrt[a + b*x + c*x^2]) - (Sqrt[2]*(-b + Sqrt[b^2 - 4*a*c])^(3/2)*(4*b*(2*b^2 - 9*a*c)*(b^2 - 3*a*c) - (a*c*(8*b^4 - 51*a*b^2*c + 60*a^2*c^2))/(b - Sqrt[b^2 - 4*a*c]))*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(1155*c^(9/2)*Sqrt[a + b*x + c*x^2])}
{Sqrt[x]*(a + b*x + c*x^2)^(3/2), x, 7, -((2*Sqrt[x]*(b*(4*b^2 - 9*a*c) + 6*c*(2*b^2 - 7*a*c)*x)*Sqrt[a + b*x + c*x^2])/(315*c^2)) + (2*b*Sqrt[x]*(a + b*x + c*x^2)^(3/2))/(21*c) + (2/9)*x^(3/2)*(a + b*x + c*x^2)^(3/2) - ((-(1/c))^(7/2)*(8*b^4 - 57*a*b^2*c + 84*a^2*c^2)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(315*Sqrt[2]*Sqrt[a + b*x + c*x^2]) + ((-b + Sqrt[b^2 - 4*a*c])^(3/2)*(8*b^4 - 57*a*b^2*c + 84*a^2*c^2 - (8*a*b*c*(b^2 - 6*a*c))/(b - Sqrt[b^2 - 4*a*c]))*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(315*Sqrt[2]*c^(7/2)*Sqrt[a + b*x + c*x^2])}
{(a + b*x + c*x^2)^(3/2)/Sqrt[x], x, 6, (2*Sqrt[x]*(b^2 + 10*a*c + 3*b*c*x)*Sqrt[a + b*x + c*x^2])/(35*c) + (2/7)*Sqrt[x]*(a + b*x + c*x^2)^(3/2) - (Sqrt[2]*b*(-(1/c))^(5/2)*(b^2 - 8*a*c)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(35*Sqrt[a + b*x + c*x^2]) + (Sqrt[2]*Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(b^4 - 9*a*b^2*c + 20*a^2*c^2 - b*(b^2 - 8*a*c)*Sqrt[b^2 - 4*a*c])*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(35*c^(5/2)*Sqrt[a + b*x + c*x^2])}
{(a + b*x + c*x^2)^(3/2)/x^(3/2), x, 6, (2*Sqrt[x]*(7*b + 6*c*x)*Sqrt[a + b*x + c*x^2])/5 - (2*(a + b*x + c*x^2)^(3/2))/Sqrt[x] - ((-c^(-1))^(3/2)*(b^2 + 12*a*c)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-c^(-1)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(5*Sqrt[2]*Sqrt[a + b*x + c*x^2]) - (Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(b^3 - 4*a*b*c - Sqrt[b^2 - 4*a*c]*(b^2 + 12*a*c))*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(5*Sqrt[2]*c^(3/2)*Sqrt[a + b*x + c*x^2])}
{(a + b*x + c*x^2)^(3/2)/x^(5/2), x, 6, (-2*(3*b - 2*c*x)*Sqrt[a + b*x + c*x^2])/(3*Sqrt[x]) - (2*(a + b*x + c*x^2)^(3/2))/(3*x^(3/2)) + (4*Sqrt[2]*b*Sqrt[-c^(-1)]*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-c^(-1)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(3*Sqrt[a + b*x + c*x^2]) - (Sqrt[2]*Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(b^2 - 4*a*c - 4*b*Sqrt[b^2 - 4*a*c])*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(3*Sqrt[c]*Sqrt[a + b*x + c*x^2])}
{(a + b*x + c*x^2)^(3/2)/x^(7/2), x, 7, (-2*(b^2 + 12*a*c)*Sqrt[a + b*x + c*x^2])/(5*a*Sqrt[x]) - (2*(b - 6*c*x)*Sqrt[a + b*x + c*x^2])/(5*x^(3/2)) - (2*(a + b*x + c*x^2)^(3/2))/(5*x^(5/2)) + (Sqrt[-c^(-1)]*(b^2 + 12*a*c)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-c^(-1)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(5*Sqrt[2]*a*Sqrt[a + b*x + c*x^2]) - (Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(b^3 - 4*a*b*c - Sqrt[b^2 - 4*a*c]*(b^2 + 12*a*c))*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(5*Sqrt[2]*a*Sqrt[c]*Sqrt[a + b*x + c*x^2])}
{(a + b*x + c*x^2)^(3/2)/x^(9/2), x, 8, -((2*(b^2 - 20*a*c)*Sqrt[a + b*x + c*x^2])/(35*a*x^(3/2))) + (4*b*(b^2 - 8*a*c)*Sqrt[a + b*x + c*x^2])/(35*a^2*Sqrt[x]) - (6*(b + 10*c*x)*Sqrt[a + b*x + c*x^2])/(35*x^(5/2)) - (2*(a + b*x + c*x^2)^(3/2))/(7*x^(7/2)) - (Sqrt[2]*b*Sqrt[-(1/c)]*(b^2 - 8*a*c)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(35*a^2*Sqrt[a + b*x + c*x^2]) + (Sqrt[2]*Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(b^4 - 9*a*b^2*c + 20*a^2*c^2 - b*(b^2 - 8*a*c)*Sqrt[b^2 - 4*a*c])*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(35*a^2*Sqrt[c]*Sqrt[a + b*x + c*x^2])}


{Sqrt[x]*(a + b*x + c*x^2)^(5/2), x, 8, (2*Sqrt[x]*(b*(24*b^4 - 151*a*b^2*c + 108*a^2*c^2) + 3*c*(24*b^4 - 181*a*b^2*c + 308*a^2*c^2)*x)*Sqrt[a + b*x + c*x^2])/(9009*c^3) - (10*Sqrt[x]*(3*b*(6*b^2 - 19*a*c) + 14*c*(3*b^2 - 11*a*c)*x)*(a + b*x + c*x^2)^(3/2))/(9009*c^2) + (10*b*Sqrt[x]*(a + b*x + c*x^2)^(5/2))/(143*c) + (2/13)*x^(3/2)*(a + b*x + c*x^2)^(5/2) - (Sqrt[2]*(-(1/c))^(9/2)*(24*b^6 - 268*a*b^4*c + 951*a^2*b^2*c^2 - 924*a^3*c^3)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(9009*Sqrt[a + b*x + c*x^2]) - (Sqrt[2]*(-b + Sqrt[b^2 - 4*a*c])^(3/2)*(24*b^6 - 268*a*b^4*c + 951*a^2*b^2*c^2 - 924*a^3*c^3 - (a*b*c*(24*b^4 - 241*a*b^2*c + 708*a^2*c^2))/(b - Sqrt[b^2 - 4*a*c]))*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(9009*c^(9/2)*Sqrt[a + b*x + c*x^2])}
{(a + b*x + c*x^2)^(5/2)/Sqrt[x], x, 7, -((2*Sqrt[x]*(4*b^4 - 27*a*b^2*c - 180*a^2*c^2 + 12*b*c*(b^2 - 8*a*c)*x)*Sqrt[a + b*x + c*x^2])/(693*c^2)) + (10*Sqrt[x]*(3*(b^2 + 6*a*c) + 7*b*c*x)*(a + b*x + c*x^2)^(3/2))/(693*c) + (2/11)*Sqrt[x]*(a + b*x + c*x^2)^(5/2) - (b*(-(1/c))^(7/2)*(8*b^4 - 93*a*b^2*c + 372*a^2*c^2)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(693*Sqrt[2]*Sqrt[a + b*x + c*x^2]) + ((-b + Sqrt[b^2 - 4*a*c])^(3/2)*(8*b^5 - 93*a*b^3*c + 372*a^2*b*c^2 - (4*a*c*(2*b^4 - 21*a*b^2*c + 180*a^2*c^2))/(b - Sqrt[b^2 - 4*a*c]))*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(693*Sqrt[2]*c^(7/2)*Sqrt[a + b*x + c*x^2])}
{(a + b*x + c*x^2)^(5/2)/x^(3/2), x, 7, (2*Sqrt[x]*(b*(b^2 + 108*a*c) + 3*c*(b^2 + 28*a*c)*x)*Sqrt[a + b*x + c*x^2])/(63*c) + (10/63)*Sqrt[x]*(15*b + 14*c*x)*(a + b*x + c*x^2)^(3/2) - (2*(a + b*x + c*x^2)^(5/2))/Sqrt[x] - (Sqrt[2]*(-(1/c))^(5/2)*(b^4 - 15*a*b^2*c - 84*a^2*c^2)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(63*Sqrt[a + b*x + c*x^2]) - (Sqrt[2]*(-b + Sqrt[b^2 - 4*a*c])^(3/2)*(b^4 - 15*a*b^2*c - 84*a^2*c^2 - (a*b*c*(b^2 - 132*a*c))/(b - Sqrt[b^2 - 4*a*c]))*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(63*c^(5/2)*Sqrt[a + b*x + c*x^2])}
{(a + b*x + c*x^2)^(5/2)/x^(5/2), x, 7, (2*Sqrt[x]*(51*b^2 + 20*a*c + 48*b*c*x)*Sqrt[a + b*x + c*x^2])/21 - (10*(7*b - 2*c*x)*(a + b*x + c*x^2)^(3/2))/(21*Sqrt[x]) - (2*(a + b*x + c*x^2)^(5/2))/(3*x^(3/2)) - (b*(-c^(-1))^(3/2)*(3*b^2 + 116*a*c)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-c^(-1)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(21*Sqrt[2]*Sqrt[a + b*x + c*x^2]) - (Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(3*b^4 + 8*a*b^2*c - 80*a^2*c^2 - b*Sqrt[b^2 - 4*a*c]*(3*b^2 + 116*a*c))*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(21*Sqrt[2]*c^(3/2)*Sqrt[a + b*x + c*x^2])}
{(a + b*x + c*x^2)^(5/2)/x^(7/2), x, 7, (-2*(3*(5*b^2 + 12*a*c) - 16*b*c*x)*Sqrt[a + b*x + c*x^2])/(15*Sqrt[x]) - (2*(5*b - 6*c*x)*(a + b*x + c*x^2)^(3/2))/(15*x^(3/2)) - (2*(a + b*x + c*x^2)^(5/2))/(5*x^(5/2)) + (Sqrt[2]*Sqrt[-c^(-1)]*(23*b^2 + 36*a*c)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-c^(-1)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(15*Sqrt[a + b*x + c*x^2]) - (Sqrt[2]*Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(8*b^3 - 32*a*b*c - Sqrt[b^2 - 4*a*c]*(23*b^2 + 36*a*c))*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(15*Sqrt[c]*Sqrt[a + b*x + c*x^2])}
{(a + b*x + c*x^2)^(5/2)/x^(9/2), x, 8, -((2*b*(3*b^2 + 116*a*c)*Sqrt[a + b*x + c*x^2])/(21*a*Sqrt[x])) - (2*(3*b^2 + 20*a*c - 48*b*c*x)*Sqrt[a + b*x + c*x^2])/(21*x^(3/2)) - (2*(3*b - 10*c*x)*(a + b*x + c*x^2)^(3/2))/(21*x^(5/2)) - (2*(a + b*x + c*x^2)^(5/2))/(7*x^(7/2)) + (b*Sqrt[-(1/c)]*(3*b^2 + 116*a*c)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(21*Sqrt[2]*a*Sqrt[a + b*x + c*x^2]) - (Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(3*b^4 + 8*a*b^2*c - 80*a^2*c^2 - b*Sqrt[b^2 - 4*a*c]*(3*b^2 + 116*a*c))*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(21*Sqrt[2]*a*Sqrt[c]*Sqrt[a + b*x + c*x^2])}
{(a + b*x + c*x^2)^(5/2)/x^(11/2), x, 9, -((2*b*(b^2 - 132*a*c)*Sqrt[a + b*x + c*x^2])/(63*a*x^(3/2))) + (4*(b^4 - 15*a*b^2*c - 84*a^2*c^2)*Sqrt[a + b*x + c*x^2])/(63*a^2*Sqrt[x]) - (2*(b^2 + 28*a*c + 80*b*c*x)*Sqrt[a + b*x + c*x^2])/(21*x^(5/2)) - (10*(b - 14*c*x)*(a + b*x + c*x^2)^(3/2))/(63*x^(7/2)) - (2*(a + b*x + c*x^2)^(5/2))/(9*x^(9/2)) - (Sqrt[2]*Sqrt[-(1/c)]*(b^4 - 15*a*b^2*c - 84*a^2*c^2)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(63*a^2*Sqrt[a + b*x + c*x^2]) - (Sqrt[2]*(-b + Sqrt[b^2 - 4*a*c])^(3/2)*(b^4 - 15*a*b^2*c - 84*a^2*c^2 - (a*b*c*(b^2 - 132*a*c))/(b - Sqrt[b^2 - 4*a*c]))*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(63*a^2*Sqrt[c]*Sqrt[a + b*x + c*x^2])}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^(5/2)/Sqrt[a + b*x + c*x^2], x, 6, -((8*b*Sqrt[x]*Sqrt[a + b*x + c*x^2])/(15*c^2)) + (2*x^(3/2)*Sqrt[a + b*x + c*x^2])/(5*c) - ((-(1/c))^(7/2)*(8*b^2 - 9*a*c)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(15*Sqrt[2]*Sqrt[a + b*x + c*x^2]) - (Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(8*b^3 - 17*a*b*c - (8*b^2 - 9*a*c)*Sqrt[b^2 - 4*a*c])*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(15*Sqrt[2]*c^(7/2)*Sqrt[a + b*x + c*x^2])}
{x^(3/2)/Sqrt[a + b*x + c*x^2], x, 5, (2*Sqrt[x]*Sqrt[a + b*x + c*x^2])/(3*c) - (Sqrt[2]*b*(-(1/c))^(5/2)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(3*Sqrt[a + b*x + c*x^2]) + (Sqrt[2]*Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(b^2 - a*c - b*Sqrt[b^2 - 4*a*c])*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(3*c^(5/2)*Sqrt[a + b*x + c*x^2])}
{Sqrt[x]/Sqrt[a + b*x + c*x^2], x, 4, -(((-(1/c))^(3/2)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(Sqrt[2]*Sqrt[a + b*x + c*x^2])) + ((-b + Sqrt[b^2 - 4*a*c])^(3/2)*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(Sqrt[2]*c^(3/2)*Sqrt[a + b*x + c*x^2])}
{1/(Sqrt[x]*Sqrt[a + b*x + c*x^2]), x, 2, (Sqrt[2]*Sqrt[-b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(Sqrt[c]*Sqrt[a + b*x + c*x^2])}
{1/(x^(3/2)*Sqrt[a + b*x + c*x^2]), x, 6, -((2*Sqrt[a + b*x + c*x^2])/(a*Sqrt[x])) + (Sqrt[-(1/c)]*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(Sqrt[2]*a*Sqrt[a + b*x + c*x^2]) + ((-b + Sqrt[b^2 - 4*a*c])^(3/2)*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(Sqrt[2]*a*Sqrt[c]*Sqrt[a + b*x + c*x^2])}
{1/(x^(5/2)*Sqrt[a + b*x + c*x^2]), x, 6, (-2*Sqrt[a + b*x + c*x^2])/(3*a*x^(3/2)) + (4*b*Sqrt[a + b*x + c*x^2])/(3*a^2*Sqrt[x]) - (Sqrt[2]*b*Sqrt[-c^(-1)]*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-c^(-1)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(3*a^2*Sqrt[a + b*x + c*x^2]) + (Sqrt[2]*Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(b^2 - a*c - b*Sqrt[b^2 - 4*a*c])*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(3*a^2*Sqrt[c]*Sqrt[a + b*x + c*x^2])}
{1/(x^(7/2)*Sqrt[a + b*x + c*x^2]), x, 7, (-2*Sqrt[a + b*x + c*x^2])/(5*a*x^(5/2)) + (8*b*Sqrt[a + b*x + c*x^2])/(15*a^2*x^(3/2)) - (2*(8*b^2 - 9*a*c)*Sqrt[a + b*x + c*x^2])/(15*a^3*Sqrt[x]) + (Sqrt[-c^(-1)]*(8*b^2 - 9*a*c)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-c^(-1)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(15*Sqrt[2]*a^3*Sqrt[a + b*x + c*x^2]) - (Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(8*b^3 - 17*a*b*c - (8*b^2 - 9*a*c)*Sqrt[b^2 - 4*a*c])*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(15*Sqrt[2]*a^3*Sqrt[c]*Sqrt[a + b*x + c*x^2])}


{x^(7/2)/(a + b*x + c*x^2)^(3/2), x, 7, (2*x^(5/2)*(2*a + b*x))/((b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2]) + (4*(2*b^2 - 5*a*c)*Sqrt[x]*Sqrt[a + b*x + c*x^2])/(3*c^2*(b^2 - 4*a*c)) - (2*b*x^(3/2)*Sqrt[a + b*x + c*x^2])/(c*(b^2 - 4*a*c)) + (b*(-(1/c))^(7/2)*(8*b^2 - 29*a*c)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(3*Sqrt[2]*(b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2]) + (Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(8*b^4 - 37*a*b^2*c + 20*a^2*c^2 - b*(8*b^2 - 29*a*c)*Sqrt[b^2 - 4*a*c])*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(3*Sqrt[2]*c^(7/2)*(b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2])}
{x^(5/2)/(a + b*x + c*x^2)^(3/2), x, 6, (2*x^(3/2)*(2*a + b*x))/((b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2]) - (2*b*Sqrt[x]*Sqrt[a + b*x + c*x^2])/(c*(b^2 - 4*a*c)) + (Sqrt[2]*(-(1/c))^(5/2)*(b^2 - 3*a*c)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/((b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2]) - (Sqrt[2]*Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(b^3 - 4*a*b*c - Sqrt[b^2 - 4*a*c]*(b^2 - 3*a*c))*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(c^(5/2)*(b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2])}
{x^(3/2)/(a + b*x + c*x^2)^(3/2), x, 5, (2*Sqrt[x]*(2*a + b*x))/((b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2]) + (b*(-c^(-1))^(3/2)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-c^(-1)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(Sqrt[2]*(b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2]) + (Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(b^2 - 4*a*c - b*Sqrt[b^2 - 4*a*c])*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(Sqrt[2]*c^(3/2)*(b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2])}
{Sqrt[x]/(a + b*x + c*x^2)^(3/2), x, 5, -((2*Sqrt[x]*(b + 2*c*x))/((b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2])) + (Sqrt[2]*Sqrt[-(1/c)]*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/((b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2]) + (Sqrt[2]*Sqrt[-b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(Sqrt[c]*Sqrt[b^2 - 4*a*c]*Sqrt[a + b*x + c*x^2])}
{1/(Sqrt[x]*(a + b*x + c*x^2)^(3/2)), x, 5, (2*Sqrt[x]*(b^2 - 2*a*c + b*c*x))/(a*(b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2]) - (b*Sqrt[-c^(-1)]*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-c^(-1)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(Sqrt[2]*a*(b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2]) + (Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(b^2 - 4*a*c - b*Sqrt[b^2 - 4*a*c])*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(Sqrt[2]*a*Sqrt[c]*(b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2])}
{1/(x^(3/2)*(a + b*x + c*x^2)^(3/2)), x, 6, (2*(b^2 - 2*a*c + b*c*x))/(a*(b^2 - 4*a*c)*Sqrt[x]*Sqrt[a + b*x + c*x^2]) - (4*(b^2 - 3*a*c)*Sqrt[a + b*x + c*x^2])/(a^2*(b^2 - 4*a*c)*Sqrt[x]) + (Sqrt[2]*Sqrt[-c^(-1)]*(b^2 - 3*a*c)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-c^(-1)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(a^2*(b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2]) - (Sqrt[2]*Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(b^3 - 4*a*b*c - Sqrt[b^2 - 4*a*c]*(b^2 - 3*a*c))*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(a^2*Sqrt[c]*(b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2])}
{1/(x^(5/2)*(a + b*x + c*x^2)^(3/2)), x, 7, (2*(b^2 - 2*a*c + b*c*x))/(a*(b^2 - 4*a*c)*x^(3/2)*Sqrt[a + b*x + c*x^2]) - (4*(2*b^2 - 5*a*c)*Sqrt[a + b*x + c*x^2])/(3*a^2*(b^2 - 4*a*c)*x^(3/2)) + (2*b*(8*b^2 - 29*a*c)*Sqrt[a + b*x + c*x^2])/(3*a^3*(b^2 - 4*a*c)*Sqrt[x]) - (b*Sqrt[-c^(-1)]*(8*b^2 - 29*a*c)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-c^(-1)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(3*Sqrt[2]*a^3*(b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2]) + (Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(8*b^4 - 37*a*b^2*c + 20*a^2*c^2 - b*(8*b^2 - 29*a*c)*Sqrt[b^2 - 4*a*c])*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(3*Sqrt[2]*a^3*Sqrt[c]*(b^2 - 4*a*c)*Sqrt[a + b*x + c*x^2])}


{x^(7/2)/(a + b*x + c*x^2)^(5/2), x, 7, (2*x^(5/2)*(2*a + b*x))/(3*(b^2 - 4*a*c)*(a + b*x + c*x^2)^(3/2)) + (2*x^(3/2)*(8*a*b - (b^2 - 20*a*c)*x))/(3*(b^2 - 4*a*c)^2*Sqrt[a + b*x + c*x^2]) + (2*(b^2 - 20*a*c)*Sqrt[x]*Sqrt[a + b*x + c*x^2])/(3*c*(b^2 - 4*a*c)^2) - (Sqrt[2]*b*(-(1/c))^(5/2)*(b^2 - 8*a*c)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(3*(b^2 - 4*a*c)^2*Sqrt[a + b*x + c*x^2]) + (Sqrt[2]*Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(b^4 - 9*a*b^2*c + 20*a^2*c^2 - b*(b^2 - 8*a*c)*Sqrt[b^2 - 4*a*c])*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(3*c^(5/2)*(b^2 - 4*a*c)^2*Sqrt[a + b*x + c*x^2])}
{x^(5/2)/(a + b*x + c*x^2)^(5/2), x, 6, (2*x^(3/2)*(2*a + b*x))/(3*(b^2 - 4*a*c)*(a + b*x + c*x^2)^(3/2)) + (2*Sqrt[x]*(8*a*b + (b^2 + 12*a*c)*x))/(3*(b^2 - 4*a*c)^2*Sqrt[a + b*x + c*x^2]) + ((-(1/c))^(3/2)*(b^2 + 12*a*c)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(3*Sqrt[2]*(b^2 - 4*a*c)^2*Sqrt[a + b*x + c*x^2]) + (Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(b^3 - 4*a*b*c - Sqrt[b^2 - 4*a*c]*(b^2 + 12*a*c))*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(3*Sqrt[2]*c^(3/2)*(b^2 - 4*a*c)^2*Sqrt[a + b*x + c*x^2])}
{x^(3/2)/(a + b*x + c*x^2)^(5/2), x, 6, (2*Sqrt[x]*(2*a + b*x))/(3*(b^2 - 4*a*c)*(a + b*x + c*x^2)^(3/2)) - (2*Sqrt[x]*(5*b^2 - 4*a*c + 8*b*c*x))/(3*(b^2 - 4*a*c)^2*Sqrt[a + b*x + c*x^2]) + (4*Sqrt[2]*b*Sqrt[-(1/c)]*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(3*(b^2 - 4*a*c)^2*Sqrt[a + b*x + c*x^2]) - (Sqrt[2]*Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(b^2 - 4*a*c - 4*b*Sqrt[b^2 - 4*a*c])*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(3*Sqrt[c]*(b^2 - 4*a*c)^2*Sqrt[a + b*x + c*x^2])}
{Sqrt[x]/(a + b*x + c*x^2)^(5/2), x, 6, -((2*Sqrt[x]*(b + 2*c*x))/(3*(b^2 - 4*a*c)*(a + b*x + c*x^2)^(3/2))) + (2*Sqrt[x]*(b*(b^2 + 4*a*c) + c*(b^2 + 12*a*c)*x))/(3*a*(b^2 - 4*a*c)^2*Sqrt[a + b*x + c*x^2]) - (Sqrt[-(1/c)]*(b^2 + 12*a*c)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(3*Sqrt[2]*a*(b^2 - 4*a*c)^2*Sqrt[a + b*x + c*x^2]) + (Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(b^3 - 4*a*b*c - Sqrt[b^2 - 4*a*c]*(b^2 + 12*a*c))*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(3*Sqrt[2]*a*Sqrt[c]*(b^2 - 4*a*c)^2*Sqrt[a + b*x + c*x^2])}
{1/(Sqrt[x]*(a + b*x + c*x^2)^(5/2)), x, 6, (2*Sqrt[x]*(b^2 - 2*a*c + b*c*x))/(3*a*(b^2 - 4*a*c)*(a + b*x + c*x^2)^(3/2)) + (2*Sqrt[x]*(2*b^4 - 17*a*b^2*c + 20*a^2*c^2 + 2*b*c*(b^2 - 8*a*c)*x))/(3*a^2*(b^2 - 4*a*c)^2*Sqrt[a + b*x + c*x^2]) - (Sqrt[2]*b*Sqrt[-c^(-1)]*(b^2 - 8*a*c)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-c^(-1)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(3*a^2*(b^2 - 4*a*c)^2*Sqrt[a + b*x + c*x^2]) + (Sqrt[2]*Sqrt[-b + Sqrt[b^2 - 4*a*c]]*(b^4 - 9*a*b^2*c + 20*a^2*c^2 - b*(b^2 - 8*a*c)*Sqrt[b^2 - 4*a*c])*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(3*a^2*Sqrt[c]*(b^2 - 4*a*c)^2*Sqrt[a + b*x + c*x^2])}
{1/(x^(3/2)*(a + b*x + c*x^2)^(5/2)), x, 7, (2*(b^2 - 2*a*c + b*c*x))/(3*a*(b^2 - 4*a*c)*Sqrt[x]*(a + b*x + c*x^2)^(3/2)) + (2*(4*b^4 - 27*a*b^2*c + 28*a^2*c^2 + 4*b*c*(b^2 - 6*a*c)*x))/(3*a^2*(b^2 - 4*a*c)^2*Sqrt[x]*Sqrt[a + b*x + c*x^2]) - (2*(8*b^4 - 57*a*b^2*c + 84*a^2*c^2)*Sqrt[a + b*x + c*x^2])/(3*a^3*(b^2 - 4*a*c)^2*Sqrt[x]) + (Sqrt[-(1/c)]*(8*b^4 - 57*a*b^2*c + 84*a^2*c^2)*(b - Sqrt[b^2 - 4*a*c])*Sqrt[b + Sqrt[b^2 - 4*a*c]]*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticE[ArcSin[(Sqrt[2]*Sqrt[x])/(Sqrt[-(1/c)]*Sqrt[b + Sqrt[b^2 - 4*a*c]])], (b + Sqrt[b^2 - 4*a*c])/(b - Sqrt[b^2 - 4*a*c])])/(3*Sqrt[2]*a^3*(b^2 - 4*a*c)^2*Sqrt[a + b*x + c*x^2]) + ((-b + Sqrt[b^2 - 4*a*c])^(3/2)*(8*b^4 - 57*a*b^2*c + 84*a^2*c^2 - (8*a*b*c*(b^2 - 6*a*c))/(b - Sqrt[b^2 - 4*a*c]))*Sqrt[1 + (2*c*x)/(b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x)/(b + Sqrt[b^2 - 4*a*c])]*EllipticF[ArcSin[(Sqrt[2]*Sqrt[c]*Sqrt[x])/Sqrt[-b + Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(3*Sqrt[2]*a^3*Sqrt[c]*(b^2 - 4*a*c)^2*Sqrt[a + b*x + c*x^2])}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/3) (a+b x+c x^2)^p*)


{(3 - x + x^2)/x^(1/3), x, 2, (9*x^(2/3))/2 - (3*x^(5/3))/5 + (3*x^(8/3))/8}
